/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, scope=DiagnosticScope.BSL, modules={ModuleType.ObjectModule, ModuleType.RecordSetModule, ModuleType.ValueManagerModule}, minutesToFix=5, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE, DiagnosticTag.UNPREDICTABLE})
public class DataExchangeLoadingDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern searchSubNames = CaseInsensitivePattern.compile((String)"^(\u041f\u0435\u0440\u0435\u0434\u0417\u0430\u043f\u0438\u0441\u044c\u044e|\u041f\u0440\u0438\u0417\u0430\u043f\u0438\u0441\u0438|\u041f\u0435\u0440\u0435\u0434\u0423\u0434\u0430\u043b\u0435\u043d\u0438\u0435\u043c|BeforeWrite|BeforeDelete|OnWrite)$");
    private static final Pattern searchCondition = CaseInsensitivePattern.compile((String)"\u041e\u0431\u043c\u0435\u043d\u0414\u0430\u043d\u043d\u044b\u043c\u0438\\.\u0417\u0430\u0433\u0440\u0443\u0437\u043a\u0430|DataExchange\\.Load");
    private static final boolean FIND_FIRST = false;
    @DiagnosticParameter(type=Boolean.class, defaultValue="false")
    private boolean findFirst = false;

    public ParseTree visitProcDeclaration(BSLParser.ProcDeclarationContext ctx) {
        Optional.of(ctx).map(BSLParser.ProcDeclarationContext::subName).filter(subName -> searchSubNames.matcher(subName.getText()).find() && !this.checkPassed(ctx)).flatMap(context -> Optional.of(this.documentContext.getSymbolTree()).flatMap(symbolTree -> symbolTree.getMethodSymbol((BSLParserRuleContext)((BSLParser.SubContext)DataExchangeLoadingDiagnostic.getSubContext(ctx))))).ifPresent(methodSymbol -> this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange()));
        return ctx;
    }

    private boolean checkPassed(BSLParser.ProcDeclarationContext ctx) {
        AtomicInteger orderStatement = new AtomicInteger();
        return Optional.of(ctx).map(BSLParserRuleContext::getParent).map(BSLParser.ProcedureContext.class::cast).map(BSLParser.ProcedureContext::subCodeBlock).map(BSLParser.SubCodeBlockContext::codeBlock).map(BSLParser.CodeBlockContext::statement).flatMap(context -> context.stream().filter(statement -> {
            orderStatement.getAndIncrement();
            if (this.findFirst && orderStatement.get() > 1) {
                return false;
            }
            return DataExchangeLoadingDiagnostic.foundLoadConditionWithReturn(statement);
        }).findFirst()).isPresent();
    }

    private static boolean foundLoadConditionWithReturn(BSLParser.StatementContext ctx) {
        return Optional.of(ctx).map(BSLParser.StatementContext::compoundStatement).map(BSLParser.CompoundStatementContext::ifStatement).map(BSLParser.IfStatementContext::ifBranch).filter(context -> searchCondition.matcher(context.expression().getText()).find() && DataExchangeLoadingDiagnostic.foundReturnStatement(context)).isPresent();
    }

    private static boolean foundReturnStatement(BSLParser.IfBranchContext ifBranch) {
        return Optional.ofNullable(ifBranch.codeBlock()).map(codeBlockContext -> Trees.findAllRuleNodes((ParseTree)codeBlockContext, 53)).map(list -> !list.isEmpty()).orElse(false);
    }

    private static ParserRuleContext getSubContext(BSLParser.ProcDeclarationContext ctx) {
        return Trees.getAncestorByRuleIndex(ctx.getRuleContext(), 36);
    }
}

