/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.Describable;
import com.github._1c_syntax.bsl.languageserver.context.symbol.Symbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.SourceDefinedSymbolDescription;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.Optional;
import lombok.Generated;
import org.eclipse.lsp4j.SymbolKind;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=3, tags={DiagnosticTag.DEPRECATED, DiagnosticTag.DESIGN})
public class DeprecatedMethodCallDiagnostic
extends AbstractDiagnostic {
    private final ReferenceIndex referenceIndex;

    @Override
    public void check() {
        URI uri = this.documentContext.getUri();
        this.referenceIndex.getReferencesFrom(uri).stream().filter(reference -> reference.getSymbol().getSymbolKind() == SymbolKind.Method).filter(reference -> reference.getSymbol().isDeprecated()).filter(reference -> !reference.getFrom().isDeprecated()).forEach(reference -> {
            Symbol deprecatedSymbol = reference.getSymbol();
            String deprecationInfo = DeprecatedMethodCallDiagnostic.getDeprecationInfo(deprecatedSymbol);
            String message = this.info.getMessage(deprecatedSymbol.getName(), deprecationInfo);
            this.diagnosticStorage.addDiagnostic(reference.getSelectionRange(), message);
        });
    }

    private static String getDeprecationInfo(Symbol deprecatedSymbol) {
        return Optional.of(deprecatedSymbol).filter(Describable.class::isInstance).map(Describable.class::cast).flatMap(Describable::getDescription).map(SourceDefinedSymbolDescription::getDeprecationInfo).orElse("");
    }

    @ConstructorProperties(value={"referenceIndex"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public DeprecatedMethodCallDiagnostic(ReferenceIndex referenceIndex) {
        this.referenceIndex = referenceIndex;
    }
}

