/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.annotations.CompilerDirectiveKind;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractFindMethodDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, scope=DiagnosticScope.BSL, minutesToFix=5, tags={DiagnosticTag.BADPRACTICE})
public class FormDataToValueDiagnostic
extends AbstractFindMethodDiagnostic {
    private static final Pattern MESSAGE_PATTERN = CaseInsensitivePattern.compile((String)"\u0414\u0430\u043d\u043d\u044b\u0435\u0424\u043e\u0440\u043c\u044b\u0412\u0417\u043d\u0430\u0447\u0435\u043d\u0438\u0435|FormDataToValue");

    public FormDataToValueDiagnostic() {
        super(MESSAGE_PATTERN);
    }

    @Override
    protected boolean checkGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        BSLParser.SubContext parentNode = (BSLParser.SubContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, 36);
        if (parentNode == null) {
            return false;
        }
        boolean isContextMethod = this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)parentNode).flatMap(MethodSymbol::getCompilerDirectiveKind).filter(compilerDirective -> compilerDirective == CompilerDirectiveKind.AT_SERVER_NO_CONTEXT || compilerDirective == CompilerDirectiveKind.AT_CLIENT_AT_SERVER_NO_CONTEXT).isEmpty();
        if (isContextMethod) {
            return MESSAGE_PATTERN.matcher(ctx.methodName().getText()).matches();
        }
        return false;
    }
}

