/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=3, activatedByDefault=false, tags={DiagnosticTag.STANDARD})
public class FunctionNameStartsWithGetDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern get = CaseInsensitivePattern.compile((String)"^\u041f\u043e\u043b\u0443\u0447\u0438\u0442\u044c.*$");

    public ParseTree visitFuncDeclaration(BSLParser.FuncDeclarationContext ctx) {
        BSLParser.SubNameContext subName = ctx.subName();
        if (subName == null) {
            return ctx;
        }
        if (get.matcher(subName.getText()).matches()) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)subName);
        }
        return ctx;
    }
}

