/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCompatibilityMode;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, minutesToFix=10, tags={DiagnosticTag.ERROR, DiagnosticTag.UNPREDICTABLE}, compatibilityMode=DiagnosticCompatibilityMode.COMPATIBILITY_MODE_8_3_12)
public class GlobalContextMethodCollision8312Diagnostic
extends AbstractDiagnostic {
    private static final Pattern COLLISION_METHODS = CaseInsensitivePattern.compile((String)"(\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c\u0411\u0438\u0442|\u041f\u0440\u043e\u0432\u0435\u0440\u0438\u0442\u044c\u041f\u043e\u0411\u0438\u0442\u043e\u0432\u043e\u0439\u041c\u0430\u0441\u043a\u0435|\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u0438\u0442\u044c\u0411\u0438\u0442|\u041f\u043e\u0431\u0438\u0442\u043e\u0432\u043e\u0435\u0418|\u041f\u043e\u0431\u0438\u0442\u043e\u0432\u043e\u0435\u0418\u043b\u0438|\u041f\u043e\u0431\u0438\u0442\u043e\u0432\u043e\u0435\u041d\u0435|\u041f\u043e\u0431\u0438\u0442\u043e\u0432\u043e\u0435\u0418\u041d\u0435|\u041f\u043e\u0431\u0438\u0442\u043e\u0432\u043e\u0435\u0418\u0441\u043a\u043b\u044e\u0447\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435\u0418\u043b\u0438|\u041f\u043e\u0431\u0438\u0442\u043e\u0432\u044b\u0439\u0421\u0434\u0432\u0438\u0433\u0412\u043b\u0435\u0432\u043e|\u041f\u043e\u0431\u0438\u0442\u043e\u0432\u044b\u0439\u0421\u0434\u0432\u0438\u0433\u0412\u043f\u0440\u0430\u0432\u043e|CheckBit|CheckByBitMask|SetBit|BitwiseAnd|BitwiseOr|BitwiseNot|BitwiseAndNot|BitwiseXor|BitwiseShiftLeft|BitwiseShiftRight)");

    @Override
    protected void check() {
        this.documentContext.getSymbolTree().getMethods().stream().filter(method -> COLLISION_METHODS.matcher(method.getName()).matches()).forEach(method -> this.diagnosticStorage.addDiagnostic(method.getSubNameRange(), this.info.getMessage(method.getName())));
    }
}

