/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=10, tags={DiagnosticTag.SUSPICIOUS})
public class IfElseDuplicatedCodeBlockDiagnostic
extends AbstractVisitorDiagnostic {
    private String relatedMessage;
    private final Set<BSLParser.CodeBlockContext> checkedBlocks = new HashSet<BSLParser.CodeBlockContext>();

    @PostConstruct
    public void init() {
        this.relatedMessage = this.info.getResourceString("identicalCodeBlockRelatedMessage");
    }

    public ParseTree visitIfStatement(BSLParser.IfStatementContext ctx) {
        this.checkedBlocks.clear();
        ArrayList<BSLParser.CodeBlockContext> codeBlocks = new ArrayList<BSLParser.CodeBlockContext>();
        codeBlocks.add(ctx.ifBranch().codeBlock());
        ctx.elsifBranch().stream().map(BSLParser.ElsifBranchContext::codeBlock).collect(Collectors.toCollection(() -> codeBlocks));
        BSLParser.ElseBranchContext elseBranch = ctx.elseBranch();
        if (elseBranch != null) {
            codeBlocks.add(elseBranch.codeBlock());
        }
        this.findDuplicatedCodeBlock(codeBlocks);
        return (ParseTree)super.visitIfStatement(ctx);
    }

    private void findDuplicatedCodeBlock(List<BSLParser.CodeBlockContext> codeBlockContexts) {
        for (int i = 0; i < codeBlockContexts.size() - 1; ++i) {
            if (this.checkedBlocks.contains(codeBlockContexts.get(i))) continue;
            this.checkCodeBlock(codeBlockContexts, i);
        }
    }

    private void checkCodeBlock(List<BSLParser.CodeBlockContext> codeBlockContexts, int i) {
        BSLParser.CodeBlockContext currentCodeBlock = codeBlockContexts.get(i);
        List identicalCodeBlocks = codeBlockContexts.stream().skip(i).filter(codeBlockContext -> !codeBlockContext.equals(currentCodeBlock) && (currentCodeBlock.children != null || codeBlockContext.children != null) && DiagnosticHelper.equalNodes((Tree)currentCodeBlock, (Tree)codeBlockContext)).collect(Collectors.toList());
        if (identicalCodeBlocks.isEmpty()) {
            return;
        }
        identicalCodeBlocks.stream().collect(Collectors.toCollection(() -> this.checkedBlocks));
        ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
        relatedInformation.add(RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)currentCodeBlock), this.relatedMessage));
        identicalCodeBlocks.stream().map(codeBlockContext -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)codeBlockContext), this.relatedMessage)).collect(Collectors.toCollection(() -> relatedInformation));
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)currentCodeBlock, relatedInformation);
    }
}

