/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=10, tags={DiagnosticTag.SUSPICIOUS})
public class IfElseDuplicatedConditionDiagnostic
extends AbstractVisitorDiagnostic {
    private String relatedMessage;
    private final Set<BSLParser.ExpressionContext> checkedConditions = new HashSet<BSLParser.ExpressionContext>();

    @PostConstruct
    public void init() {
        this.relatedMessage = this.info.getResourceString("identicalConditionRelatedMessage");
    }

    public ParseTree visitIfStatement(BSLParser.IfStatementContext ctx) {
        this.checkedConditions.clear();
        ArrayList<BSLParser.ExpressionContext> expressions = new ArrayList<BSLParser.ExpressionContext>();
        expressions.add(ctx.ifBranch().expression());
        ctx.elsifBranch().stream().map(BSLParser.ElsifBranchContext::expression).collect(Collectors.toCollection(() -> expressions));
        this.findDuplicatedExpression(expressions);
        return (ParseTree)super.visitIfStatement(ctx);
    }

    private void findDuplicatedExpression(List<BSLParser.ExpressionContext> expressionContexts) {
        for (int i = 0; i < expressionContexts.size() - 1; ++i) {
            if (this.checkedConditions.contains(expressionContexts.get(i))) continue;
            this.checkExpression(expressionContexts, i);
        }
    }

    private void checkExpression(List<BSLParser.ExpressionContext> expressionContexts, int i) {
        BSLParser.ExpressionContext currentExpression = expressionContexts.get(i);
        List identicalExpressions = expressionContexts.stream().skip(i).filter(expressionContext -> !expressionContext.equals(currentExpression) && DiagnosticHelper.equalNodes((Tree)currentExpression, (Tree)expressionContext)).collect(Collectors.toList());
        if (identicalExpressions.isEmpty()) {
            return;
        }
        identicalExpressions.stream().collect(Collectors.toCollection(() -> this.checkedConditions));
        ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
        relatedInformation.add(RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)currentExpression), this.relatedMessage));
        identicalExpressions.stream().map(expressionContext -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)expressionContext), this.relatedMessage)).collect(Collectors.toCollection(() -> relatedInformation));
        this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)currentExpression, relatedInformation);
    }
}

