/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.parser.SDBLParser;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.INFO, minutesToFix=2, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class IncorrectLineBreakDiagnostic
extends AbstractDiagnostic {
    private static final boolean DEFAULT_CHECK_START = true;
    private static final String DEFAULT_LIST_FOR_CHECK_START = "\\)|;|,|\\);";
    private static final boolean DEFAULT_CHECK_END = true;
    private static final String DEFAULT_LIST_FOR_CHECK_END = "\u0418\u041b\u0418|\u0418|OR|AND|\\+|-|/|%|\\*";
    private static final int QUERY_START_LINE_OFFSET = 2;
    private static final Pattern IN_STRING = Pattern.compile("[\"|][^\"\\n]+(?:\"|$)", 8);
    private final Set<Integer> queryFirstLines = new HashSet<Integer>();
    private final Map<Integer, Integer> commentStarts = new HashMap<Integer, Integer>();
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean checkFirstSymbol = true;
    @DiagnosticParameter(type=String.class, defaultValue="\\)|;|,|\\);")
    private Pattern listOfIncorrectFirstSymbol = IncorrectLineBreakDiagnostic.createPatternIncorrectStartLine("\\)|;|,|\\);");
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean checkLastSymbol = true;
    @DiagnosticParameter(type=String.class, defaultValue="\u0418\u041b\u0418|\u0418|OR|AND|\\+|-|/|%|\\*")
    private Pattern listOfIncorrectLastSymbol = IncorrectLineBreakDiagnostic.createPatternIncorrectEndLine("\u0418\u041b\u0418|\u0418|OR|AND|\\+|-|/|%|\\*");

    @Override
    public void configure(Map<String, Object> configuration) {
        DiagnosticHelper.configureDiagnostic(this, configuration, "checkFirstSymbol", "checkLastSymbol");
        this.listOfIncorrectFirstSymbol = IncorrectLineBreakDiagnostic.createPatternIncorrectStartLine((String)configuration.getOrDefault("listOfIncorrectFirstSymbol", DEFAULT_LIST_FOR_CHECK_START));
        this.listOfIncorrectLastSymbol = IncorrectLineBreakDiagnostic.createPatternIncorrectEndLine((String)configuration.getOrDefault("listOfIncorrectLastSymbol", DEFAULT_LIST_FOR_CHECK_END));
    }

    @Override
    protected void check() {
        this.findCommentStarts();
        this.findQueryFirstLines();
        if (this.checkFirstSymbol) {
            this.checkContent(this.listOfIncorrectFirstSymbol);
        }
        if (this.checkLastSymbol) {
            this.checkContent(this.listOfIncorrectLastSymbol);
        }
    }

    private void findCommentStarts() {
        this.documentContext.getComments().forEach(token -> this.commentStarts.put(token.getLine() - 1, token.getCharPositionInLine()));
    }

    private void findQueryFirstLines() {
        this.documentContext.getQueries().forEach(query -> this.queryFirstLines.add(((SDBLParser.QueryPackageContext)query.getAst()).getStart().getLine()));
    }

    private void checkContent(Pattern pattern) {
        String[] contentList = this.documentContext.getContentList();
        for (int line = 0; line < contentList.length; ++line) {
            boolean inString;
            Matcher matcher;
            boolean found;
            String checkText = contentList[line];
            boolean queryStartsAtNextLine = this.queryFirstLines.contains(line + 2);
            if (queryStartsAtNextLine || !(found = (matcher = pattern.matcher(checkText)).find())) continue;
            int start = matcher.start(1);
            int end = matcher.end(1);
            boolean inComment = this.isInComment(line, end);
            if (inComment || (inString = IncorrectLineBreakDiagnostic.isInString(checkText, start, end))) continue;
            this.diagnosticStorage.addDiagnostic(line, start, line, end);
        }
    }

    private boolean isInComment(int line, int end) {
        return end >= this.commentStarts.getOrDefault(line, Integer.MAX_VALUE);
    }

    private static boolean isInString(String checkText, int start, int end) {
        Matcher inStringMatcher = IN_STRING.matcher(checkText);
        while (inStringMatcher.find()) {
            if (inStringMatcher.start() > start || inStringMatcher.end() < end) continue;
            return true;
        }
        return false;
    }

    private static Pattern getPatternSearch(String startPattern, String searchSymbols, String endPattern) {
        return CaseInsensitivePattern.compile((String)(startPattern + searchSymbols + endPattern));
    }

    private static Pattern createPatternIncorrectStartLine(String listOfSymbols) {
        return IncorrectLineBreakDiagnostic.getPatternSearch("^\\s*(:?", listOfSymbols, ")");
    }

    private static Pattern createPatternIncorrectEndLine(String listOfSymbols) {
        return IncorrectLineBreakDiagnostic.getPatternSearch("\\s+(:?", listOfSymbols, ")\\s*(?://.*)?$");
    }
}

