/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, scope=DiagnosticScope.BSL, minutesToFix=5, tags={DiagnosticTag.ERROR})
public class IsInRoleMethodDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern IS_IN_ROLE_NAME_PATTERN = CaseInsensitivePattern.compile((String)"(\u0420\u043e\u043b\u044c\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u0430|IsInRole)");
    private static final Pattern PRIVILEGED_MODE_NAME_PATTERN = CaseInsensitivePattern.compile((String)"(\u041f\u0440\u0438\u0432\u0438\u043b\u0435\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u043d\u044b\u0439\u0420\u0435\u0436\u0438\u043c|PrivilegedMode)");
    private static final Set<Integer> ROOT_PARENTS_FOR_GLOBAL_METHODS = Set.of(Integer.valueOf(45), Integer.valueOf(78));
    private final Set<String> isInRoleVars = new HashSet<String>();
    private final Set<String> privilegedModeNameVars = new HashSet<String>();

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        this.isInRoleVars.clear();
        this.privilegedModeNameVars.clear();
        return (ParseTree)super.visitFile(ctx);
    }

    public ParseTree visitIfBranch(BSLParser.IfBranchContext ctx) {
        this.computeDiagnostics(ctx.expression());
        return (ParseTree)super.visitIfBranch(ctx);
    }

    public ParseTree visitElsifBranch(BSLParser.ElsifBranchContext ctx) {
        this.computeDiagnostics(ctx.expression());
        return (ParseTree)super.visitElsifBranch(ctx);
    }

    private void computeDiagnostics(BSLParser.ExpressionContext expression) {
        Trees.findAllRuleNodes((ParseTree)expression, 92).stream().map(complexCtx -> (BSLParser.ComplexIdentifierContext)complexCtx).filter(complexCtx -> this.isInRoleVars.contains(complexCtx.getText())).filter(ctx -> this.checkStatement((BSLParserRuleContext)ctx, (BSLParserRuleContext)expression)).forEach(this.diagnosticStorage::addDiagnostic);
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        String text = ctx.methodName().getText();
        if (IS_IN_ROLE_NAME_PATTERN.matcher(text).matches()) {
            this.handleIsInRoleGlobalMethod(ctx);
        } else if (PRIVILEGED_MODE_NAME_PATTERN.matcher(text).matches()) {
            this.handlePrivilegedModeGlobalMethod(ctx);
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    private void handleIsInRoleGlobalMethod(BSLParser.GlobalMethodCallContext ctx) {
        BSLParserRuleContext rootParent = Trees.getRootParent((BSLParserRuleContext)ctx, ROOT_PARENTS_FOR_GLOBAL_METHODS);
        if (rootParent == null) {
            return;
        }
        if (rootParent.getRuleIndex() == 45) {
            if (this.checkStatement((BSLParserRuleContext)ctx)) {
                this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
            }
        } else if (rootParent.getRuleIndex() == 78) {
            IsInRoleMethodDiagnostic.addAssignedNameVar(rootParent, this.isInRoleVars);
        }
    }

    private void handlePrivilegedModeGlobalMethod(BSLParser.GlobalMethodCallContext ctx) {
        BSLParserRuleContext assignmentNode = Trees.getRootParent((BSLParserRuleContext)ctx, 78);
        if (assignmentNode != null) {
            IsInRoleMethodDiagnostic.addAssignedNameVar(assignmentNode, this.privilegedModeNameVars);
        }
    }

    private static void addAssignedNameVar(BSLParserRuleContext assignmentNode, Set<String> nameVars) {
        Optional<BSLParserRuleContext> childNode = Trees.getFirstChild((Tree)assignmentNode, 95);
        childNode.ifPresent(node -> nameVars.add(node.getText()));
    }

    public ParseTree visitAssignment(BSLParser.AssignmentContext ctx) {
        Optional<BSLParserRuleContext> childNode = Trees.getFirstChild((Tree)ctx, 95);
        childNode.ifPresent(node -> {
            this.isInRoleVars.remove(node.getText());
            this.privilegedModeNameVars.remove(node.getText());
        });
        return (ParseTree)super.visitAssignment(ctx);
    }

    private boolean checkStatement(BSLParserRuleContext ctx) {
        BSLParserRuleContext parentExpression = Trees.getRootParent(ctx, 81);
        return this.checkStatement(ctx, parentExpression);
    }

    private boolean checkStatement(BSLParserRuleContext ctx, @Nullable BSLParserRuleContext parentExpression) {
        if (parentExpression == null) {
            return false;
        }
        Collection<ParseTree> identifierList = Trees.findAllRuleNodes((ParseTree)parentExpression, 92);
        for (ParseTree parseTree : identifierList) {
            if (!this.privilegedModeNameVars.contains(parseTree.getText())) continue;
            return false;
        }
        ParseTree nextGlobalMethodNode = Trees.getNextNode((ParseTree)parentExpression, (ParseTree)ctx, 90);
        boolean hasPrivilegedModeCheck = nextGlobalMethodNode instanceof BSLParser.GlobalMethodCallContext && PRIVILEGED_MODE_NAME_PATTERN.matcher(((BSLParser.GlobalMethodCallContext)nextGlobalMethodNode).methodName().getText()).matches();
        return !hasPrivilegedModeCheck;
    }
}

