/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.mdclasses.Configuration;
import com.github._1c_syntax.mdclasses.common.ConfigurationSource;
import com.github._1c_syntax.mdclasses.mdo.MDCommonModule;
import com.github._1c_syntax.mdclasses.mdo.MDEventSubscription;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.BLOCKER, minutesToFix=5, tags={DiagnosticTag.ERROR}, scope=DiagnosticScope.BSL, modules={ModuleType.SessionModule})
public class MissingEventSubscriptionHandlerDiagnostic
extends AbstractDiagnostic {
    private Range diagnosticRange;
    private static final Pattern SPLIT_PATTERN = Pattern.compile("\\.");

    @Override
    protected void check() {
        Configuration configuration = this.documentContext.getServerContext().getConfiguration();
        if (configuration.getConfigurationSource() == ConfigurationSource.EMPTY) {
            return;
        }
        this.diagnosticRange = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (Ranges.isEmpty(this.diagnosticRange)) {
            return;
        }
        configuration.getChildren().stream().filter(mdo -> mdo.getType() == MDOType.EVENT_SUBSCRIPTION).map(MDEventSubscription.class::cast).forEach(eventSubs -> {
            if (eventSubs.getHandler().isEmpty()) {
                this.addDiagnostic((MDEventSubscription)eventSubs);
                return;
            }
            String[] handlerParts = SPLIT_PATTERN.split(eventSubs.getHandler());
            if (handlerParts.length != 3) {
                this.addDiagnostic("incorrectHandler", (MDEventSubscription)eventSubs, eventSubs.getHandler());
                return;
            }
            Optional module = configuration.getCommonModule(handlerParts[1]);
            if (module.isEmpty()) {
                this.addDiagnostic("missingModule", (MDEventSubscription)eventSubs, handlerParts[1]);
                return;
            }
            MDCommonModule commonModule = (MDCommonModule)module.get();
            if (!commonModule.isServer()) {
                this.addDiagnostic("shouldBeServer", (MDEventSubscription)eventSubs, handlerParts[1]);
            }
            this.checkMethod((MDEventSubscription)eventSubs, handlerParts[2], commonModule);
        });
    }

    private void checkMethod(MDEventSubscription eventSubs, String methodName, MDCommonModule commonModule) {
        this.documentContext.getServerContext().getDocument(commonModule.getMdoReference().getMdoRef(), ModuleType.CommonModule).ifPresent(commonModuleContext -> {
            Optional<MethodSymbol> method = commonModuleContext.getSymbolTree().getMethods().stream().filter(methodSymbol -> methodSymbol.getName().equalsIgnoreCase(methodName)).findFirst();
            if (method.isEmpty()) {
                this.addDiagnostic("missingMethod", eventSubs, commonModule.getName() + "." + methodName);
                return;
            }
            if (!method.get().isExport()) {
                this.addDiagnostic("nonExportMethod", eventSubs, commonModule.getName() + "." + methodName);
            }
        });
    }

    private void addDiagnostic(String messageString, MDEventSubscription eventSubs, String text) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getResourceString(messageString, text, eventSubs.getName()));
    }

    private void addDiagnostic(MDEventSubscription eventSubs) {
        this.diagnosticStorage.addDiagnostic(this.diagnosticRange, this.info.getMessage(eventSubs.getName()));
    }
}

