/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=2, tags={DiagnosticTag.STANDARD, DiagnosticTag.BRAINOVERLOAD, DiagnosticTag.BADPRACTICE})
public class NestedFunctionInParametersDiagnostic
extends AbstractVisitorDiagnostic {
    private static final boolean DEFAULT_ALLOW_ONELINER = true;
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean allowOneliner = true;

    public ParseTree visitMethodCall(BSLParser.MethodCallContext ctx) {
        this.checkMethodCall((BSLParserRuleContext)ctx, ctx.doCall(), ctx.methodName());
        return (ParseTree)super.visitMethodCall(ctx);
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        this.checkMethodCall((BSLParserRuleContext)ctx, ctx.doCall(), ctx.methodName());
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        if (!this.findNestedCall((BSLParserRuleContext)ctx, ctx.doCall())) {
            return (ParseTree)super.visitNewExpression(ctx);
        }
        if (ctx.typeName() != null) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx.typeName(), this.info.getMessage(this.info.getResourceString("diagnosticMessageConstructor"), ctx.typeName().getText()));
        } else {
            this.diagnosticStorage.addDiagnostic(ctx.getStart(), this.info.getResourceString("diagnosticMessageWithoutName", this.info.getResourceString("diagnosticMessageConstructor")));
        }
        return (ParseTree)super.visitNewExpression(ctx);
    }

    private boolean findNestedCall(BSLParserRuleContext ctx, BSLParser.DoCallContext ctxDoCall) {
        if (ctxDoCall == null || ctxDoCall.callParamList() == null || ctxDoCall.callParamList().isEmpty()) {
            return false;
        }
        return ctx.getStart().getLine() != ctx.getStop().getLine() && Trees.nodeContains((ParseTree)ctx, (ParseTree)ctxDoCall, 99) && this.multilineParam(ctxDoCall);
    }

    private boolean multilineParam(BSLParser.DoCallContext ctxDoCall) {
        return !this.allowOneliner || ctxDoCall.callParamList().callParam().stream().anyMatch(callParamContext -> callParamContext.getStop().getLine() > callParamContext.getStart().getLine());
    }

    private void checkMethodCall(BSLParserRuleContext ctx, BSLParser.DoCallContext ctxDoCall, BSLParser.MethodNameContext ctxMethodName) {
        if (this.findNestedCall(ctx, ctxDoCall)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctxMethodName, this.info.getMessage(this.info.getResourceString("diagnosticMessageMethod"), ctxMethodName.getText()));
        }
    }
}

