/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractListenerDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.CRITICAL, scope=DiagnosticScope.ALL, minutesToFix=30, tags={DiagnosticTag.BADPRACTICE, DiagnosticTag.BRAINOVERLOAD})
public class NestedStatementsDiagnostic
extends AbstractListenerDiagnostic {
    private String relatedMessage;
    private static final int MAX_ALLOWED_LEVEL = 4;
    @DiagnosticParameter(type=Integer.class, defaultValue="4")
    private int maxAllowedLevel = 4;
    private ParseTree lastCtx;
    private final Deque<ParseTree> nestedParents = new ArrayDeque<ParseTree>();

    @PostConstruct
    public void init() {
        this.relatedMessage = this.info.getResourceString("parentStatementRelatedMessage");
    }

    public void enterIfStatement(BSLParser.IfStatementContext ctx) {
        this.enterNode((BSLParserRuleContext)ctx);
    }

    public void exitIfStatement(BSLParser.IfStatementContext ctx) {
        this.exitNode((BSLParserRuleContext)ctx);
    }

    public void enterWhileStatement(BSLParser.WhileStatementContext ctx) {
        this.enterNode((BSLParserRuleContext)ctx);
    }

    public void exitWhileStatement(BSLParser.WhileStatementContext ctx) {
        this.exitNode((BSLParserRuleContext)ctx);
    }

    public void enterForStatement(BSLParser.ForStatementContext ctx) {
        this.enterNode((BSLParserRuleContext)ctx);
    }

    public void exitForStatement(BSLParser.ForStatementContext ctx) {
        this.exitNode((BSLParserRuleContext)ctx);
    }

    public void enterForEachStatement(BSLParser.ForEachStatementContext ctx) {
        this.enterNode((BSLParserRuleContext)ctx);
    }

    public void exitForEachStatement(BSLParser.ForEachStatementContext ctx) {
        this.exitNode((BSLParserRuleContext)ctx);
    }

    public void enterTryStatement(BSLParser.TryStatementContext ctx) {
        this.enterNode((BSLParserRuleContext)ctx);
    }

    public void exitTryStatement(BSLParser.TryStatementContext ctx) {
        this.exitNode((BSLParserRuleContext)ctx);
    }

    private void enterNode(BSLParserRuleContext ctx) {
        this.lastCtx = ctx;
        this.nestedParents.push((ParseTree)ctx);
    }

    private void exitNode(BSLParserRuleContext ctx) {
        if (ctx == this.lastCtx && this.nestedParents.size() > this.maxAllowedLevel) {
            this.addRelatedInformationDiagnostic(ctx);
        }
        this.nestedParents.pop();
    }

    private void addRelatedInformationDiagnostic(BSLParserRuleContext ctx) {
        ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
        relatedInformation.add(RelatedInformation.create(this.documentContext.getUri(), Ranges.create(ctx.getStart()), this.relatedMessage));
        this.nestedParents.stream().filter(node -> node != ctx).map(expressionContext -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create(((BSLParserRuleContext)expressionContext).getStart()), this.relatedMessage)).collect(Collectors.toCollection(() -> relatedInformation));
        this.diagnosticStorage.addDiagnostic(ctx.getStart(), relatedInformation);
    }
}

