/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.mdclasses.Configuration;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, scope=DiagnosticScope.BSL, modules={ModuleType.SessionModule}, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.UNPREDICTABLE})
public class OrdinaryAppSupportDiagnostic
extends AbstractDiagnostic {
    private final LanguageServerConfiguration serverConfiguration;

    @Override
    protected void check() {
        if (!this.serverConfiguration.getDiagnosticsOptions().isOrdinaryAppSupport()) {
            return;
        }
        Range range = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (!Ranges.isEmpty(range)) {
            this.checkProperties(range);
        }
    }

    private void checkProperties(Range range) {
        Configuration configuration = this.documentContext.getServerContext().getConfiguration();
        if (!configuration.isUseManagedFormInOrdinaryApplication()) {
            this.diagnosticStorage.addDiagnostic(range, this.info.getResourceString("managedFormInOrdinaryApp"));
        }
        if (configuration.isUseOrdinaryFormInManagedApplication()) {
            this.diagnosticStorage.addDiagnostic(range, this.info.getResourceString("ordinaryFormInManagedApp"));
        }
    }

    @ConstructorProperties(value={"serverConfiguration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public OrdinaryAppSupportDiagnostic(LanguageServerConfiguration serverConfiguration) {
        this.serverConfiguration = serverConfiguration;
    }
}

