/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractListenerDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLLexer;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.misc.IntervalSet;
import org.antlr.v4.runtime.tree.ErrorNode;
import org.antlr.v4.runtime.tree.ErrorNodeImpl;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNodeImpl;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.CRITICAL, scope=DiagnosticScope.ALL, minutesToFix=5, tags={DiagnosticTag.ERROR})
public class ParseErrorDiagnostic
extends AbstractListenerDiagnostic {
    public static final int EOF = -1;

    public void visitErrorNode(ErrorNode node) {
        if (((ErrorNodeImpl)node).symbol.getTokenIndex() == -1) {
            this.diagnosticStorage.addDiagnostic(((BSLParserRuleContext)node.getParent()).getStart(), this.info.getMessage(node.getText()));
        }
    }

    public void enterFile(BSLParser.FileContext ctx) {
        BSLParser.FileContext ast = this.documentContext.getAst();
        String initialExpectedString = this.info.getResourceString("expectedTokens") + " ";
        Trees.getDescendants((ParseTree)ast).stream().filter(parseTree -> !(parseTree instanceof TerminalNodeImpl)).map(parseTree -> (BSLParserRuleContext)parseTree).filter(node -> node.exception != null).forEach(node -> {
            IntervalSet expectedTokens = node.exception.getExpectedTokens();
            StringJoiner sj = new StringJoiner(", ");
            expectedTokens.getIntervals().stream().flatMapToInt(interval -> IntStream.range(interval.a, interval.b)).mapToObj(ParseErrorDiagnostic::getTokenName).forEachOrdered(sj::add);
            Token errorToken = node.exception.getOffendingToken();
            if (errorToken.getType() == -1) {
                errorToken = node.getStart();
            }
            this.diagnosticStorage.addDiagnostic(errorToken, this.info.getMessage(initialExpectedString + sj));
        });
    }

    private static String getTokenName(int tokenType) {
        String value = BSLLexer.VOCABULARY.getLiteralName(tokenType);
        if (value == null) {
            value = BSLLexer.VOCABULARY.getSymbolicName(tokenType);
        }
        return value;
    }
}

