/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractSDBLVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.bsl.parser.SDBLParser;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.Tree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, scope=DiagnosticScope.BSL, minutesToFix=5, tags={DiagnosticTag.SQL, DiagnosticTag.PERFORMANCE})
public class RefOveruseDiagnostic
extends AbstractSDBLVisitorDiagnostic {
    private static final String REF_REGEX = "\u0421\u0441\u044b\u043b\u043a\u0430|Reference";
    private static final Pattern REF_PATTERN = CaseInsensitivePattern.compile((String)"\u0421\u0441\u044b\u043b\u043a\u0430|Reference");
    private static final int BAD_CHILD_COUNT = 3;
    private Collection<ParseTree> dataSourceCollection = new ArrayList<ParseTree>();

    public ParseTree visitQuery(SDBLParser.QueryContext ctx) {
        Collection<ParseTree> columnsCollection = Trees.findAllRuleNodes((ParseTree)ctx, 25);
        if (columnsCollection.isEmpty() || this.dataSourceCollection.stream().anyMatch(Trees::treeContainsErrors)) {
            return ctx;
        }
        if (this.dataSourceCollection.isEmpty()) {
            this.performSimpleCheck(columnsCollection);
            return ctx;
        }
        Set tableNames = this.dataSourceCollection.stream().map(RefOveruseDiagnostic::getTableNameOrAlias).collect(Collectors.toSet());
        columnsCollection.forEach(column -> this.checkColumnNode((SDBLParser.ColumnContext)column, tableNames));
        return ctx;
    }

    public ParseTree visitSelectQuery(SDBLParser.SelectQueryContext ctx) {
        this.dataSourceCollection = Trees.findAllRuleNodes((ParseTree)ctx, 47);
        return (ParseTree)super.visitSelectQuery(ctx);
    }

    private void performSimpleCheck(Collection<ParseTree> columnsCollection) {
        columnsCollection.stream().filter(columnNode -> columnNode.getChildCount() > 3).map(column -> column.getChild(column.getChildCount() - 1)).filter(lastChild -> REF_PATTERN.matcher(lastChild.getText()).matches()).forEach(node -> this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)node));
    }

    private void checkColumnNode(SDBLParser.ColumnContext ctx, Set<String> tableNames) {
        if (ctx.children == null) {
            return;
        }
        int childCount = ctx.children.size();
        if (childCount < 3) {
            return;
        }
        ParseTree lastChild = ctx.getChild(childCount - 1);
        ParseTree penultimateChild = ctx.getChild(childCount - 3);
        String lastIdentifierName = lastChild.getText();
        String penultimateIdentifierName = penultimateChild.getText();
        if (REF_PATTERN.matcher(penultimateIdentifierName).matches() || REF_PATTERN.matcher(lastIdentifierName).matches() && !tableNames.contains(penultimateIdentifierName)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx);
        }
    }

    private static String getTableNameOrAlias(ParseTree dataSource) {
        return Optional.of(dataSource).flatMap(dataSrc -> RefOveruseDiagnostic.extractTextFromChild(dataSrc, 53)).or(() -> Optional.of(dataSource).flatMap(dataSrc -> RefOveruseDiagnostic.extractTextFromChild(dataSrc, 48))).or(() -> Optional.of(dataSource).flatMap(dataSrc -> RefOveruseDiagnostic.extractTextFromChild(dataSrc, 51))).orElse("");
    }

    private static Optional<String> extractTextFromChild(ParseTree parseTree, int childRuleType) {
        return Optional.of(parseTree).flatMap(tree -> Trees.getFirstChild((Tree)tree, childRuleType)).flatMap(child -> Trees.getFirstChild((Tree)child, 57)).map(BSLParserRuleContext::getText);
    }
}

