/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDO;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.lsp4j.Range;

@DiagnosticMetadata(type=DiagnosticType.VULNERABILITY, severity=DiagnosticSeverity.CRITICAL, scope=DiagnosticScope.BSL, modules={ModuleType.ManagedApplicationModule}, minutesToFix=1, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE, DiagnosticTag.DESIGN})
public class SetPermissionsForNewObjectsDiagnostic
extends AbstractDiagnostic {
    private static final String NAMES_FULL_ACCESS_ROLE = "FullAccess,\u041f\u043e\u043b\u043d\u044b\u0435\u041f\u0440\u0430\u0432\u0430";
    @DiagnosticParameter(type=String.class, defaultValue="FullAccess,\u041f\u043e\u043b\u043d\u044b\u0435\u041f\u0440\u0430\u0432\u0430")
    private Set<String> namesFullAccessRole = SetPermissionsForNewObjectsDiagnostic.getSetFromString("FullAccess,\u041f\u043e\u043b\u043d\u044b\u0435\u041f\u0440\u0430\u0432\u0430");

    @Override
    public void check() {
        Range range = this.documentContext.getSymbolTree().getModule().getSelectionRange();
        if (Ranges.isEmpty(range)) {
            return;
        }
        this.documentContext.getServerContext().getConfiguration().getRoles().stream().filter(role -> role.getRoleData().isSetForNewObjects()).map(AbstractMDO::getName).filter(Predicate.not(this.namesFullAccessRole::contains)).map(xva$0 -> this.info.getMessage(xva$0)).forEach(diagnosticMessage -> this.diagnosticStorage.addDiagnostic(range, (String)diagnosticMessage));
    }

    @Override
    public void configure(Map<String, Object> configuration) {
        String namesFullAccessRoleString = (String)configuration.getOrDefault("namesFullAccessRole", NAMES_FULL_ACCESS_ROLE);
        this.namesFullAccessRole = SetPermissionsForNewObjectsDiagnostic.getSetFromString(namesFullAccessRoleString);
    }

    private static Set<String> getSetFromString(String inputParam) {
        return Set.of(inputParam.split(","));
    }
}

