/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MINOR, scope=DiagnosticScope.BSL, minutesToFix=5, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class StyleElementConstructorsDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern PATTERN = CaseInsensitivePattern.compile((String)"^(\u0420\u0430\u043c\u043a\u0430|\u0426\u0432\u0435\u0442|\u0428\u0440\u0438\u0444\u0442|Color|Border|Font)$");
    private static final Pattern QUOTE_PATTERN = Pattern.compile("\"");

    public ParseTree visitNewExpression(BSLParser.NewExpressionContext ctx) {
        String ctxTypeName = StyleElementConstructorsDiagnostic.typeName(ctx);
        if (PATTERN.matcher(ctxTypeName).find()) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(ctxTypeName));
        }
        return (ParseTree)super.visitNewExpression(ctx);
    }

    private static String typeName(BSLParser.NewExpressionContext ctx) {
        if (ctx.typeName() != null) {
            return ctx.typeName().getText();
        }
        if (ctx.doCall().callParamList().isEmpty()) {
            return "";
        }
        return QUOTE_PATTERN.matcher(ctx.doCall().callParamList().callParam(0).getText()).replaceAll("");
    }
}

