/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.RelatedInformation;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.eclipse.lsp4j.DiagnosticRelatedInformation;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=20, activatedByDefault=false, tags={DiagnosticTag.BRAINOVERLOAD})
public class TooManyReturnsDiagnostic
extends AbstractVisitorDiagnostic {
    private static final int MAX_RETURNS_COUNT = 3;
    private static final int MAX_RELATION_TEXT_LENGTH = 20;
    @DiagnosticParameter(type=Integer.class, defaultValue="3")
    private int maxReturnsCount = 3;

    private static String leftSubStr(String inputString) {
        if (inputString.length() < 20) {
            return inputString;
        }
        return inputString.substring(0, 20);
    }

    private String getRelatedMessage(BSLParser.ReturnStatementContext context) {
        if (context.getChildCount() > 1) {
            return TooManyReturnsDiagnostic.leftSubStr(this.documentContext.getText(Ranges.create((ParserRuleContext)context)));
        }
        return "+1";
    }

    public ParseTree visitSub(BSLParser.SubContext ctx) {
        Optional<MethodSymbol> optionalMethodSymbol = this.documentContext.getSymbolTree().getMethodSymbol((BSLParserRuleContext)ctx);
        optionalMethodSymbol.ifPresent(methodSymbol -> {
            Collection<ParseTree> statements = Trees.findAllRuleNodes((ParseTree)ctx, 53);
            if (statements.size() > this.maxReturnsCount) {
                ArrayList<DiagnosticRelatedInformation> relatedInformation = new ArrayList<DiagnosticRelatedInformation>();
                statements.stream().map(context -> RelatedInformation.create(this.documentContext.getUri(), Ranges.create((ParserRuleContext)((BSLParser.ReturnStatementContext)context)), this.getRelatedMessage((BSLParser.ReturnStatementContext)context))).collect(Collectors.toCollection(() -> relatedInformation));
                this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), this.info.getMessage(methodSymbol.getName(), statements.size(), this.maxReturnsCount), relatedInformation);
            }
        });
        return ctx;
    }
}

