/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.hover;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.ParameterDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.TypeDescription;
import com.github._1c_syntax.bsl.languageserver.hover.MarkupContentBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.Position;
import org.springframework.stereotype.Component;

@Component
public class MethodSymbolMarkupContentBuilder
implements MarkupContentBuilder<MethodSymbol> {
    private static final String PROCEDURE_KEY = "procedure";
    private static final String FUNCTION_KEY = "function";
    private static final String EXPORT_KEY = "export";
    private static final String VAL_KEY = "val";
    private static final String PARAMETERS_KEY = "parameters";
    private static final String RETURNED_VALUE_KEY = "returnedValue";
    private static final String EXAMPLES_KEY = "examples";
    private static final String CALL_OPTIONS_KEY = "callOptions";
    private static final String PARAMETER_TEMPLATE = "* **%s**: %s";
    private final LanguageServerConfiguration configuration;

    @Override
    public MarkupContent getContent(MethodSymbol symbol) {
        StringJoiner markupBuilder = new StringJoiner("\n");
        String signature = this.getSignature(symbol);
        MethodSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, signature);
        String methodLocation = MethodSymbolMarkupContentBuilder.getLocation(symbol);
        MethodSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, methodLocation);
        String purposeSection = MethodSymbolMarkupContentBuilder.getPurposeSection(symbol);
        MethodSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, purposeSection);
        String parametersSection = this.getParametersSection(symbol);
        MethodSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, parametersSection);
        String returnedValueSection = this.getReturnedValueSection(symbol);
        MethodSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, returnedValueSection);
        String examplesSection = this.getExamplesSection(symbol);
        MethodSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, examplesSection);
        String callOptionsSection = this.getCallOptionsSection(symbol);
        MethodSymbolMarkupContentBuilder.addSectionIfNotEmpty(markupBuilder, callOptionsSection);
        String content = markupBuilder.toString();
        return new MarkupContent("markdown", content);
    }

    @Override
    public Class<MethodSymbol> getType() {
        return MethodSymbol.class;
    }

    private static void addSectionIfNotEmpty(StringJoiner markupBuilder, String newContent) {
        if (!newContent.isEmpty()) {
            markupBuilder.add(newContent);
            markupBuilder.add("");
            markupBuilder.add("---");
        }
    }

    private static String getPurposeSection(MethodSymbol methodSymbol) {
        return methodSymbol.getDescription().map(MethodDescription::getPurposeDescription).orElse("");
    }

    private String getParametersSection(MethodSymbol methodSymbol) {
        StringJoiner result = new StringJoiner("  \n");
        int level = 0;
        methodSymbol.getParameters().forEach(parameterDefinition -> {
            if (parameterDefinition.getDescription().isPresent()) {
                result.add(MethodSymbolMarkupContentBuilder.parameterToString(parameterDefinition.getDescription().get(), level));
            } else {
                result.add(MethodSymbolMarkupContentBuilder.parameterToString(parameterDefinition));
            }
        });
        String parameters = result.toString();
        if (!parameters.isBlank()) {
            StringJoiner parametersSection = new StringJoiner("\n");
            String header = "**" + this.getResourceString(PARAMETERS_KEY) + ":**";
            parametersSection.add(header);
            parametersSection.add("");
            parametersSection.add(parameters);
            return parametersSection.toString();
        }
        return "";
    }

    private String getReturnedValueSection(MethodSymbol methodSymbol) {
        StringJoiner result = new StringJoiner("  \n");
        methodSymbol.getDescription().ifPresent(methodDescription -> {
            Map<String, String> typesMap = MethodSymbolMarkupContentBuilder.typesToMap(methodDescription.getReturnedValue(), 0);
            result.add(MethodSymbolMarkupContentBuilder.typesMapToString(typesMap, 1));
        });
        Object returnedValue = result.toString();
        if (!((String)returnedValue).isEmpty()) {
            returnedValue = "**" + this.getResourceString(RETURNED_VALUE_KEY) + ":**\n\n" + (String)returnedValue;
        }
        return returnedValue;
    }

    private String getExamplesSection(MethodSymbol methodSymbol) {
        List examples = methodSymbol.getDescription().map(MethodDescription::getExamples).orElseGet(Collections::emptyList);
        return this.getSectionWithCodeFences(examples, EXAMPLES_KEY);
    }

    private String getCallOptionsSection(MethodSymbol methodSymbol) {
        List callOptions = methodSymbol.getDescription().map(MethodDescription::getCallOptions).orElseGet(Collections::emptyList);
        return this.getSectionWithCodeFences(callOptions, CALL_OPTIONS_KEY);
    }

    private String getSectionWithCodeFences(List<String> codeBlocks, String resourceKey) {
        Object codeFences = codeBlocks.stream().map(codeBlock -> "```bsl\n" + codeBlock + "\n```").collect(Collectors.joining("\n"));
        if (!((String)codeFences).isEmpty()) {
            codeFences = "**" + this.getResourceString(resourceKey) + ":**\n\n" + (String)codeFences;
        }
        return codeFences;
    }

    private static String getLocation(MethodSymbol symbol) {
        DocumentContext documentContext = symbol.getOwner();
        Position startPosition = symbol.getSelectionRange().getStart();
        String mdoRef = MdoRefBuilder.getMdoRef(documentContext);
        return String.format("[%s](%s#%d)", mdoRef, documentContext.getUri(), startPosition.getLine() + 1);
    }

    private String getSignature(MethodSymbol methodSymbol) {
        String signatureTemplate = "```bsl\n%s %s(%s)%s%s\n```";
        String methodKind = methodSymbol.isFunction() ? this.getResourceString(FUNCTION_KEY) : this.getResourceString(PROCEDURE_KEY);
        String methodName = methodSymbol.getName();
        StringJoiner parametersDescription = new StringJoiner(", ");
        methodSymbol.getParameters().forEach(parameterDefinition -> {
            Object parameter = "";
            String parameterName = parameterDefinition.getName();
            if (parameterDefinition.isByValue()) {
                parameter = (String)parameter + this.getResourceString(VAL_KEY) + " ";
            }
            parameter = (String)parameter + parameterName;
            String parameterTypes = parameterDefinition.getDescription().map(ParameterDescription::getTypes).map(MethodSymbolMarkupContentBuilder::getTypes).orElse("");
            if (!parameterTypes.isEmpty()) {
                parameter = (String)parameter + ": " + parameterTypes;
            }
            if (parameterDefinition.isOptional()) {
                parameter = (String)parameter + " = ";
                parameter = (String)parameter + parameterDefinition.getDefaultValue().getValue();
            }
            parametersDescription.add((CharSequence)parameter);
        });
        String parameters = parametersDescription.toString();
        Object returnedValueType = methodSymbol.getDescription().map(MethodDescription::getReturnedValue).map(MethodSymbolMarkupContentBuilder::getTypes).orElse("");
        if (!((String)returnedValueType).isEmpty()) {
            returnedValueType = ": " + (String)returnedValueType;
        }
        String export = methodSymbol.isExport() ? " " + this.getResourceString(EXPORT_KEY) : "";
        return String.format(signatureTemplate, methodKind, methodName, parameters, export, returnedValueType);
    }

    private static String getTypes(List<TypeDescription> typeDescriptions) {
        return typeDescriptions.stream().map(TypeDescription::getName).flatMap(parameterType -> Stream.of(parameterType.split(","))).map(String::trim).collect(Collectors.joining(" | "));
    }

    private String getResourceString(String key) {
        return Resources.getResourceString(this.configuration.getLanguage(), this.getClass(), key);
    }

    private static String parameterToString(ParameterDescription parameter, int level) {
        StringJoiner result = new StringJoiner("  \n");
        Map<String, String> typesMap = MethodSymbolMarkupContentBuilder.typesToMap(parameter.getTypes(), level);
        String parameterTemplate = "  ".repeat(level) + PARAMETER_TEMPLATE;
        if (typesMap.size() == 1) {
            result.add(String.format(parameterTemplate, parameter.getName(), MethodSymbolMarkupContentBuilder.typesMapToString(typesMap, 0)));
        } else {
            result.add(String.format(parameterTemplate, parameter.getName(), ""));
            result.add(MethodSymbolMarkupContentBuilder.typesMapToString(typesMap, level + 1));
        }
        return result.toString();
    }

    private static String parameterToString(ParameterDefinition parameterDefinition) {
        return String.format(PARAMETER_TEMPLATE, parameterDefinition.getName(), "");
    }

    private static Map<String, String> typesToMap(List<TypeDescription> parameterTypes, int level) {
        HashMap<String, String> types = new HashMap<String, String>();
        parameterTypes.forEach(type -> {
            String typeDescription = MethodSymbolMarkupContentBuilder.typeToString(type, level);
            String typeName = type.isHyperlink() ? String.format("[%s](%s)", type.getName(), type.getLink()) : String.format("`%s`", type.getName());
            types.merge(typeDescription, typeName, (oldValue, newValue) -> String.format("%s | %s", oldValue, newValue));
        });
        return types;
    }

    private static String typesMapToString(Map<String, String> types, int level) {
        StringJoiner result = new StringJoiner("  \n");
        String indent = "&nbsp;&nbsp;".repeat(level);
        types.forEach((key, value) -> {
            if (key.isBlank()) {
                result.add((CharSequence)value);
            } else {
                result.add(String.format("%s%s %s", indent, value, key));
            }
        });
        return result.toString();
    }

    private static String typeToString(TypeDescription type, int level) {
        StringJoiner result = new StringJoiner("  \n");
        Object description = type.getDescription().replace("\n", "<br>" + "&nbsp;&nbsp;".repeat(level + 1));
        if (!((String)description).isBlank()) {
            description = "- " + (String)description;
        }
        if (!type.getParameters().isEmpty()) {
            description = (String)description + ":";
        }
        result.add((CharSequence)description);
        type.getParameters().forEach(parameter -> result.add(MethodSymbolMarkupContentBuilder.parameterToString(parameter, level + 1)));
        return result.toString();
    }

    @ConstructorProperties(value={"configuration"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public MethodSymbolMarkupContentBuilder(LanguageServerConfiguration configuration) {
        this.configuration = configuration;
    }
}

