/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.references;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.events.DocumentContextContentChangedEvent;
import com.github._1c_syntax.bsl.languageserver.references.ReferenceIndex;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserBaseVisitor;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.Range;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ReferenceIndexFiller {
    private static final Set<ModuleType> DEFAULT_MODULE_TYPES = EnumSet.of(ModuleType.ManagerModule, ModuleType.CommonModule, ModuleType.UNKNOWN);
    private final ReferenceIndex index;

    @EventListener
    public void handleEvent(DocumentContextContentChangedEvent event) {
        DocumentContext documentContext = event.getSource();
        this.fill(documentContext);
    }

    public void fill(DocumentContext documentContext) {
        this.index.clearReferences(documentContext.getUri());
        new ReferenceFinder(documentContext).visitFile(documentContext.getAst());
    }

    @ConstructorProperties(value={"index"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ReferenceIndexFiller(ReferenceIndex index) {
        this.index = index;
    }

    private class ReferenceFinder
    extends BSLParserBaseVisitor<BSLParserRuleContext> {
        private final DocumentContext documentContext;

        public BSLParserRuleContext visitCallStatement(BSLParser.CallStatementContext ctx) {
            if (ctx.globalMethodCall() != null) {
                return (BSLParserRuleContext)super.visitCallStatement(ctx);
            }
            String mdoRef = MdoRefBuilder.getMdoRef(this.documentContext, ctx);
            if (mdoRef.isEmpty()) {
                return (BSLParserRuleContext)super.visitCallStatement(ctx);
            }
            this.getMethodName(ctx).ifPresent(methodName -> this.checkCall(mdoRef, (Token)methodName));
            return (BSLParserRuleContext)super.visitCallStatement(ctx);
        }

        public BSLParserRuleContext visitComplexIdentifier(BSLParser.ComplexIdentifierContext ctx) {
            String mdoRef = MdoRefBuilder.getMdoRef(this.documentContext, ctx);
            if (mdoRef.isEmpty()) {
                return (BSLParserRuleContext)super.visitComplexIdentifier(ctx);
            }
            this.getMethodName(ctx).ifPresent(methodName -> this.checkCall(mdoRef, (Token)methodName));
            return (BSLParserRuleContext)super.visitComplexIdentifier(ctx);
        }

        public BSLParserRuleContext visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
            String mdoRef = MdoRefBuilder.getMdoRef(this.documentContext);
            ModuleType moduleType = this.documentContext.getModuleType();
            Token methodName = ctx.methodName().getStart();
            String methodNameText = methodName.getText();
            this.documentContext.getSymbolTree().getMethods().stream().filter(methodSymbol -> methodSymbol.getName().equalsIgnoreCase(methodNameText)).findAny().ifPresent(methodSymbol -> this.addMethodCall(mdoRef, moduleType, methodNameText, Ranges.create(methodName)));
            return (BSLParserRuleContext)super.visitGlobalMethodCall(ctx);
        }

        private void checkCall(String mdoRef, Token methodName) {
            String methodNameText = methodName.getText();
            Map modules = this.documentContext.getServerContext().getConfiguration().getModulesByMDORef(mdoRef);
            for (Map.Entry e : modules.entrySet()) {
                ModuleType moduleType = (ModuleType)e.getKey();
                if (!DEFAULT_MODULE_TYPES.contains(moduleType)) continue;
                this.addMethodCall(mdoRef, moduleType, methodNameText, Ranges.create(methodName));
            }
        }

        private void addMethodCall(String mdoRef, ModuleType moduleType, String methodName, Range range) {
            ReferenceIndexFiller.this.index.addMethodCall(this.documentContext.getUri(), mdoRef, moduleType, methodName, range);
        }

        private Optional<Token> getMethodName(BSLParser.CallStatementContext ctx) {
            List modifiers = ctx.modifier();
            Optional<Token> methodName = ctx.globalMethodCall() != null ? this.getMethodName(ctx.globalMethodCall()) : this.getMethodName(ctx.accessCall());
            if (modifiers.isEmpty()) {
                return methodName;
            }
            return this.getMethodName(modifiers).or(() -> methodName);
        }

        private Optional<Token> getMethodName(BSLParser.GlobalMethodCallContext ctx) {
            return Optional.of(ctx.methodName().getStart());
        }

        private Optional<Token> getMethodName(BSLParser.AccessCallContext ctx) {
            return Optional.of(ctx.methodCall().methodName().getStart());
        }

        private Optional<Token> getMethodName(BSLParser.ComplexIdentifierContext ctx) {
            return this.getMethodName(ctx.modifier());
        }

        private Optional<Token> getMethodName(List<? extends BSLParser.ModifierContext> modifiers) {
            return modifiers.stream().map(BSLParser.ModifierContext::accessCall).filter(Objects::nonNull).map(this::getMethodName).findFirst().orElse(Optional.empty());
        }

        @ConstructorProperties(value={"documentContext"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public ReferenceFinder(DocumentContext documentContext) {
            this.documentContext = documentContext;
        }
    }
}

