/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils;

import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDO;
import com.github._1c_syntax.mdclasses.mdo.support.MDOReference;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.mdclasses.utils.MDOUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import lombok.Generated;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

public final class MdoRefBuilder {
    public static String getMdoRef(DocumentContext documentContext, BSLParser.CallStatementContext callStatement) {
        if (callStatement.globalMethodCall() != null) {
            return MdoRefBuilder.getMdoRef(documentContext);
        }
        return MdoRefBuilder.getMdoRef(documentContext, callStatement.IDENTIFIER(), callStatement.modifier());
    }

    public static String getMdoRef(DocumentContext documentContext) {
        return documentContext.getMdObject().map(AbstractMDO::getMdoReference).map(MDOReference::getMdoRef).orElseGet(() -> documentContext.getUri().toString());
    }

    public static String getMdoRef(DocumentContext documentContext, BSLParser.ComplexIdentifierContext complexIdentifier) {
        return MdoRefBuilder.getMdoRef(documentContext, complexIdentifier.IDENTIFIER(), complexIdentifier.modifier());
    }

    public static String getMdoRef(DocumentContext documentContext, @Nullable TerminalNode identifier, List<? extends BSLParser.ModifierContext> modifiers) {
        AtomicReference<String> mdoRef = new AtomicReference<String>("");
        Optional.ofNullable(identifier).map(ParseTree::getText).flatMap(commonModuleName -> MdoRefBuilder.getCommonModuleMdoRef(documentContext, commonModuleName)).or(() -> Optional.ofNullable(identifier).map(ParseTree::getText).flatMap(MDOType::fromValue).filter(mdoType -> MDOUtils.getModuleTypesForMdoTypes().getOrDefault(mdoType, Collections.emptySet()).contains(ModuleType.ManagerModule)).map(mdoType -> MdoRefBuilder.getMdoRef(mdoType, MdoRefBuilder.getMdoName(modifiers)))).ifPresent(mdoRef::set);
        return mdoRef.get();
    }

    private static Optional<String> getCommonModuleMdoRef(DocumentContext documentContext, String commonModuleName) {
        return documentContext.getServerContext().getConfiguration().getCommonModule(commonModuleName).map(AbstractMDO::getMdoReference).map(MDOReference::getMdoRef);
    }

    private static String getMdoRef(MDOType mdoType, String identifier) {
        if (identifier.isEmpty()) {
            return "";
        }
        return mdoType.getName() + "." + identifier;
    }

    private static String getMdoName(List<? extends BSLParser.ModifierContext> modifiers) {
        return modifiers.stream().limit(1L).findAny().map(BSLParser.ModifierContext::accessProperty).map(BSLParser.AccessPropertyContext::IDENTIFIER).map(ParseTree::getText).orElse("");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    private MdoRefBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

