/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.utils.expressiontree;

import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.AbstractCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BinaryOperationNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslExpression;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.BslOperator;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.ConstructorCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.MethodCallNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.NodeEqualityComparer;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TerminalSymbolNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.TernaryOperatorNode;
import com.github._1c_syntax.bsl.languageserver.utils.expressiontree.UnaryOperationNode;
import java.util.List;
import org.antlr.v4.runtime.tree.Tree;

public class DefaultNodeEqualityComparer
implements NodeEqualityComparer {
    @Override
    public boolean areEqual(BslExpression first, BslExpression second) {
        if (first == second) {
            return true;
        }
        if (first.getClass() != second.getClass() || first.getNodeType() != second.getNodeType()) {
            return false;
        }
        switch (first.getNodeType()) {
            case LITERAL: {
                return this.literalsEqual((TerminalSymbolNode)first, (TerminalSymbolNode)second);
            }
            case IDENTIFIER: {
                return this.identifiersEqual((TerminalSymbolNode)first, (TerminalSymbolNode)second);
            }
            case BINARY_OP: {
                return this.binaryOperationsEqual((BinaryOperationNode)first, (BinaryOperationNode)second);
            }
            case UNARY_OP: {
                return this.unaryOperationsEqual((UnaryOperationNode)first, (UnaryOperationNode)second);
            }
            case TERNARY_OP: {
                return this.ternaryOperatorsEqual((TernaryOperatorNode)first, (TernaryOperatorNode)second);
            }
            case SKIPPED_CALL_ARG: {
                return true;
            }
            case CALL: {
                return this.callStatementsEqual((AbstractCallNode)first, (AbstractCallNode)second);
            }
        }
        throw new IllegalStateException();
    }

    protected boolean callStatementsEqual(AbstractCallNode first, AbstractCallNode second) {
        if (first instanceof MethodCallNode) {
            return this.methodCallsEqual((MethodCallNode)first, (MethodCallNode)second);
        }
        return this.constructorCallsEqual((ConstructorCallNode)first, (ConstructorCallNode)second);
    }

    protected boolean constructorCallsEqual(ConstructorCallNode first, ConstructorCallNode second) {
        return this.areEqual(first.getTypeName(), second.getTypeName()) && this.argumentsEqual(first.arguments(), second.arguments());
    }

    protected boolean argumentsEqual(List<BslExpression> argumentsOfFirst, List<BslExpression> argumentsOfSecond) {
        if (argumentsOfFirst.size() != argumentsOfSecond.size()) {
            return false;
        }
        for (int i = 0; i < argumentsOfFirst.size(); ++i) {
            if (this.areEqual(argumentsOfFirst.get(i), argumentsOfSecond.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean methodCallsEqual(MethodCallNode first, MethodCallNode second) {
        return first.getName().getText().equalsIgnoreCase(second.getName().getText()) && this.argumentsEqual(first.arguments(), second.arguments());
    }

    protected boolean ternaryOperatorsEqual(TernaryOperatorNode first, TernaryOperatorNode second) {
        return this.areEqual(first.getCondition(), second.getCondition()) && this.areEqual(first.getTruePart(), second.getTruePart()) && this.areEqual(first.getFalsePart(), second.getFalsePart());
    }

    protected boolean unaryOperationsEqual(UnaryOperationNode first, UnaryOperationNode second) {
        if (first.getOperator() != second.getOperator()) {
            return false;
        }
        return this.areEqual(first.getOperand(), second.getOperand());
    }

    protected boolean binaryOperationsEqual(BinaryOperationNode first, BinaryOperationNode second) {
        if (first.getOperator() != second.getOperator()) {
            return false;
        }
        if (first.getOperator() == BslOperator.DEREFERENCE || first.getOperator() == BslOperator.INDEX_ACCESS) {
            return false;
        }
        return this.areEqual(first.getLeft(), second.getLeft()) && this.areEqual(first.getRight(), second.getRight());
    }

    protected boolean identifiersEqual(TerminalSymbolNode first, TerminalSymbolNode second) {
        return DiagnosticHelper.equalNodes((Tree)first.getRepresentingAst(), (Tree)second.getRepresentingAst());
    }

    protected boolean literalsEqual(TerminalSymbolNode first, TerminalSymbolNode second) {
        return DiagnosticHelper.equalNodes((Tree)first.getRepresentingAst(), (Tree)second.getRepresentingAst());
    }
}

