# После вызова асинхронного метода есть строки кода (CodeAfterAsyncCall)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги     |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:------------:|
| `Дефект кода` |             `BSL`             | `Важный` |             `Нет`              |                `10`                 | `suspicious` |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->
При использовании асинхронных методов разработчики иногда ошибаются, написав код таким образом, что сразу после вызова асинхронного метода следуют строки кода. В этом случае указанные строки кода выполняются немедленно, без ожидания выполнения асинхронного метода.

Для правильного решения нужно вынести весь код, который должен быть выполнен после выполнения асинхронного действия, в экспортный метод и указать его имя в обработке оповещения, которая будет вызвана после завершения асинхронного действия.
Или использовать асинхронность через обещания, например, `Ждать ПредупреждениеАсинх(Текст);`

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

Неверный код
```bsl
&НаКлиенте
Процедура Команда1(Команда)
    ДополнительныеПараметры = Новый Структура("Результат", 10);
    Оповещение = Новый ОписаниеОповещения("ПослеВводаКоличества", ЭтотОбъект);
    ПоказатьВводЧисла(Оповещение, 1, "Введите количество", ДополнительныеПараметры.Результат, 2);

    Сообщить("Введенное количество равно " + ДополнительныеПараметры.Результат); // неверно, т.к. всегда будет 10
КонецПроцедуры

&НаКлиенте
Процедура ПослеВводаКоличества(Число, ДополнительныеПараметры) Экспорт
    Если Число <> Неопределено Тогда
         ДополнительныеПараметры.Результат = Число;
    КонецЕсли;
КонецПроцедуры;
```

Правильный код
```bsl
&НаКлиенте
Процедура Команда1(Команда)
    ДополнительныеПараметры = Новый Структура("Результат", 10);
    Оповещение = Новый ОписаниеОповещения("ПослеВводаКоличества", ЭтотОбъект);
    ПоказатьВводЧисла(Оповещение, 1, "Введите количество", ДополнительныеПараметры.Результат, 2);

КонецПроцедуры

&НаКлиенте
Процедура ПослеВводаКоличества(Число, ДополнительныеПараметры) Экспорт
    Если Число <> Неопределено Тогда
        ДополнительныеПараметры.Результат = Число;
        Сообщить("Введенное количество равно " + ДополнительныеПараметры.Результат); // неверно, т.к. всегда будет 10
    КонецЕсли;
КонецПроцедуры;
```

В некоторых случаях выполнение кода сразу после вызова асинхронного метода вполне возможно, если не нужно ожидать результатов выполнения асинхронного действия.
Например
```bsl
&НаКлиенте
Процедура Команда1(Команда)
	ПоказатьПредупреждение(, "Предупреждаю", 10);
	Сообщить("начал работать код после ПоказатьПредупреждение");
    // ...
КонецПроцедуры
```

Также важно учесть, что асинхронный метод может вызываться в одной из веток кода и нужно анализировать последующий код до конца текущей процедуры\функции.
Пример:
```bsl
&НаКлиенте
Процедура Команда1(Команда)
    ДополнительныеПараметры = Новый Структура("Результат", 10);
    Если Условие Тогда
        Оповещение = Новый ОписаниеОповещения("ПослеВводаКоличества", ЭтотОбъект);
        ПоказатьВводЧисла(Оповещение, 1, "Введите количество", ДополнительныеПараметры.Результат, 2);
    Иначе
        // какой-то код
    КонецЕсли;
    // последующий код также может вызываться сразу после вызова асинхронного метода, что может быть неверно

    Сообщить("Введенное количество равно " + ДополнительныеПараметры.Результат); // неверно, т.к. всегда будет 10
КонецПроцедуры
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->
- [Синхронные и асинхронные методы работы - Руководство разработчика Глава 4. Встроенный язык](https://its.1c.ru/db/v8319doc#bookmark:dev:TI000001505)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CodeAfterAsyncCall-off
// BSLLS:CodeAfterAsyncCall-on
```

### Параметр конфигурационного файла

```json
"CodeAfterAsyncCall": false
```
