# Код расположен вне области (CodeOutOfRegion)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |    Теги    |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:----------:|
| `Дефект кода` |             `BSL`             | `Информационный` |              `Да`              |                 `1`                 | `standard` |

## Параметры


|           Имя            |   Тип    |               Описание               |    Значение<br>по умолчанию    |
|:------------------------:|:--------:|:------------------------------------:|:------------------------------:|
| `checkUnknownModuleType` | `Булево` | `Проверять неизвестные типы модулей` |            `false`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Весь код модуля должен быть структурирован и разделен по разделам (областям).  
Требование о разделении кода модуля на разделы призвано повысить читаемость кода и упростить внесение изменений в код разными авторами (разработчиками) как при коллективной разработке, так и при доработке прикладных решений на конкретных внедрениях.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

```bsl
#Область <ИмяОбласти>
```

Не смотря на то что в стандарте описано всего 10 имён, имена вложенных областей не проверяются.

Правильно:
```bsl
#Область СлужебныеПроцедурыИФункции
#Область Печать
// Код процедур и функций
#КонецОбласти
#Область Прочее
// Код процедур и функций
#КонецОбласти
#КонецОбласти
```

Таблица соответствия английских имён (полный список в [исходном коде](https://github.com/1c-syntax/bsl-language-server/blob/develop/src/main/java/com/github/_1c_syntax/bsl/languageserver/utils/Keywords.java#L255)):
| русск.  | англ. |
| ------------- | ------------- |
| ПрограммныйИнтерфейс  | Public  |
| СлужебныйПрограммныйИнтерфейс  | Internal  |
| СлужебныеПроцедурыИФункции  | Private  |
| ОбработчикиСобытий  | EventHandlers  |
| ОбработчикиСобытийФормы  | FormEventHandlers  |
| ОбработчикиСобытийЭлементовШапкиФормы  | FormHeaderItemsEventHandlers  |
| ОбработчикиКомандФормы  | FormCommandsEventHandlers  |
| ОписаниеПеременных  | Variables  |
| Инициализация  | Initialize  |
| ОбработчикиСобытийЭлементовТаблицыФормы  | FormTableItemsEventHandlers  |

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->


* Источник [Соглашения при написания кода. Структура модуля](https://its.1c.ru/db/v8std#content:455:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CodeOutOfRegion-off
// BSLLS:CodeOutOfRegion-on
```

### Параметр конфигурационного файла

```json
"CodeOutOfRegion": {
    "checkUnknownModuleType": false
}
```
