# Директивы компиляции методов (CompilationDirectiveLost)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                Теги                 |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-----------------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `1`                 |    `standard`<br>`unpredictable`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
У всех методов управляемых форм и команд должны быть указаны директивы компиляции.

## Примеры

#### Неправильно:
```bsl
Процедура ПриСозданииНаСервере()
...
КонецПроцедуры 
```

#### Правильно:
```bsl
&НаСервере
Процедура ПриСозданииНаСервере()
...
КонецПроцедуры 
```

## Источники

* Полезная информация: [Разработка интерфейса прикладных решений на платформе "1С:Предприятие 8"](https://its.1c.ru/db/pubv8devui#content:189:1)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:CompilationDirectiveLost-off
// BSLLS:CompilationDirectiveLost-on
```

### Параметр конфигурационного файла

```json
"CompilationDirectiveLost": false
```
