# Ограничение на длину строки (LineLength)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                 `1`                 |    `standard`<br>`badpractice`    |

## Параметры


|           Имя            |   Тип    |                    Описание                    |    Значение<br>по умолчанию    |
|:------------------------:|:--------:|:----------------------------------------------:|:------------------------------:|
|     `maxLineLength`      | `Целое`  |     `Максимальная длина строки в символах`     |             `120`              |
| `checkMethodDescription` | `Булево` | `Анализировать длину строк в описании методов` |             `true`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

При длине строки более 120 символов следует использовать переносы. Строки длиннее 120 символов делать не рекомендуется, за исключением тех случаев, когда перенос невозможен (например, в коде определена длинная строковая константа, которая выводится без переносов в окно сообщений с помощью объекта СообщениеПользователю).

## Источники

* [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:LineLength-off
// BSLLS:LineLength-on
```

### Параметр конфигурационного файла

```json
"LineLength": {
    "maxLineLength": 120,
    "checkMethodDescription": true
}
```
