# Магические числа (MagicNumber)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |     Теги      |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:-------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                 `1`                 | `badpractice` |

## Параметры


|         Имя         |   Тип    |                           Описание                            |    Значение<br>по умолчанию    |
|:-------------------:|:--------:|:-------------------------------------------------------------:|:------------------------------:|
| `authorizedNumbers` | `Строка` | `Список разрешенных чисел через запятую. Например: -1,0,1,60` |            `-1,0,1`            |
| `allowMagicIndexes` | `Булево` |                `Разрешить магические индексы`                 |             `true`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Магические числа - это любое число в вашем коде, которое не сразу становится очевидным без погружения в контекст.

## Примеры

Плохо

```bsl
Функция ПопадаетВИнтервал(Длительность)

    Возврат Длительность < 10 * 60 * 60; 

КонецФункции
``` 

Хорошо

```bsl
Функция ПопадаетВИнтервал(ДлительностьВСекундах)
    
    МинутВЧасе      = 60;
    СекундВМинуте   = 60;
    СекундВЧасе     = СекундВМинуте * МинутВЧасе;
    ЧасовВИнтервале = 10;
    Возврат Длительность < ЧасовВИнтервале * СекундВЧасе; 

КонецФункции
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MagicNumber-off
// BSLLS:MagicNumber-on
```

### Параметр конфигурационного файла

```json
"MagicNumber": {
    "authorizedNumbers": "-1,0,1",
    "allowMagicIndexes": true
}
```
