# Отсутствует описание возвращаемого значения функции (MissingReturnedValueDescription)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 |    `standard`<br>`badpractice`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Описание метода (процедуры или функции) должно оформляться корректно, помогая программистам правильно использовать функциональность.

Описание функции должно содержать описание возвращаемого значения в одноименном блоке. Необходимо привести описание для всех возможных типов возвращаемого значения.

Диагностика обнаруживает типовые ошибки:

- Отсутствие описания возвращаемого значения
- Наличие описания возвращаемого значения у процедуры
- Некачественное описание возвращаемого значения: когда имя типа присутствует в описании, но не указано его описание

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

* Источник: [Стандарт: Описание процедур и функций](https://its.1c.ru/db/v8std#content:453:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MissingReturnedValueDescription-off
// BSLLS:MissingReturnedValueDescription-on
```

### Параметр конфигурационного файла

```json
"MissingReturnedValueDescription": false
```
