# Отсутствует удаление временного файла после использования (MissingTemporaryFileDeletion)

|   Тип    |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |               Теги                |
|:--------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:---------------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Важный` |              `Да`              |                 `5`                 |    `badpractice`<br>`standard`    |

## Параметры


|           Имя            |   Тип    |                           Описание                            |                                  Значение<br>по умолчанию                                   |
|:------------------------:|:--------:|:-------------------------------------------------------------:|:-------------------------------------------------------------------------------------------:|
| `searchDeleteFileMethod` | `Строка` | `Ключевые слова поиска методов удаления / перемещения файлов` | `УдалитьФайлы|DeleteFiles|НачатьУдалениеФайлов|BeginDeletingFiles|ПереместитьФайл|MoveFile` |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

После окончания работы с временным файлом или каталогом, его необходимо удалить самостоятельно. 
Нельзя рассчитывать на автоматическое удаление файлов и каталогов при следующем запуске платформы, 
это может привести к исчерпанию свободного места в каталоге временных файлов.

## Примеры

Неправильно:

```bsl
ИмяПромежуточногоФайла = ПолучитьИмяВременногоФайла("xml");
Данные.Записать(ИмяПромежуточногоФайла);
// далее нет удаления файла
```

Правильно:

```bsl
ИмяПромежуточногоФайла = ПолучитьИмяВременногоФайла("xml");
Данные.Записать(ИмяПромежуточногоФайла);

// Работа с файлом
...

// Удаляем временный файл
Попытка
   УдалитьФайлы(ИмяПромежуточногоФайла);
Исключение
   ЗаписьЖурналаРегистрации(НСтр("ru = 'Мой механизм.Действие'"), УровеньЖурналаРегистрации.Ошибка, , , ПодробноеПредставлениеОшибки(ИнформацияОбОшибке()));
КонецПопытки;
```

## Особенности работы

Диагностика определяет корректность работы с временными файлами по наличию методов удаления либо перемещения.

Если в прикладном решении используется свой метод удаления/перемещения поверх платформенного, то стоит указать его в параметре диагностики, добавив через `|`. Диагностика понимает как глобальные методы, так и расположенные в общих модулях или модулях менеджеров.

Ниже приведены примеры настройки

- Глобальный метод `МоеУдалениеФайлов` в модуле `ГлобальныйСервер` в параметре указывается как `МоеУдалениеФайлов`
- Метод `МоеУдалениеФайлов` в общем модуле `ФайлыКлиентСервер` в параметре указывается как `ФайлыКлиентСервер.МоеУдалениеФайлов`
- Метод `МоеУдалениеФайлов` в модуле менеджера справочника `ФайловыеОперации` в параметре указывается как `Справочники.ФайловыеОперации.МоеУдалениеФайлов`

и так далее.

## Источники

* [Доступ к файловой системе из кода конфигурации](https://its.1c.ru/db/v8std#content:542:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MissingTemporaryFileDeletion-off
// BSLLS:MissingTemporaryFileDeletion-on
```

### Параметр конфигурационного файла

```json
"MissingTemporaryFileDeletion": {
    "searchDeleteFileMethod": "УдалитьФайлы|DeleteFiles|НачатьУдалениеФайлов|BeginDeletingFiles|ПереместитьФайл|MoveFile"
}
```
