# Многострочный литерал в запросе (MultilineStringInQuery)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                             Теги                             |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:------------------------------------------------------------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                 `1`                 |       `badpractice`<br>`suspicious`<br>`unpredictable`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

В текстах запросов очень редко используют многострочные литералы, в основном это результаты ошибки из-за некорректного числа двойных кавычек.

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

В приведенном ниже примере в выборке будет присутствовать два поля вместо трех.

```bsl
Запрос = Новый Запрос;
Запрос.Текст = "ВЫБРАТЬ
|	ПриходныйОрдерНоменклатура.Номенклатура КАК Номенклатура,
|	ЕСТЬNULL(ПриходныйОрдерНоменклатура.Номенклатура.Код, "") КАК НоменклатураКод,
|	ЕСТЬNULL(ПриходныйОрдерНоменклатура.Номенклатура.Наименование, "") КАК НоменклатураНаименование
|ИЗ
|	Документ.ПриходныйОрдер.Номенклатура КАК ПриходныйОрдерНоменклатура
|ГДЕ
|	ПриходныйОрдерНоменклатура.Ссылка = &Ссылка";
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:MultilineStringInQuery-off
// BSLLS:MultilineStringInQuery-on
```

### Параметр конфигурационного файла

```json
"MultilineStringInQuery": false
```
