# Использование конструкторов с параметрами при объявлении структуры (NestedConstructorsInStructureDeclaration)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                  Теги                  |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:--------------------------------------:|
| `Дефект кода` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                `10`                 |    `badpractice`<br>`brainoverload`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Не рекомендуется в конструкторе структуры использовать конструкторы других объектов, если эти конструкторы принимают параметры. В частности в конструкторе одной структуры не рекомендуется создавать другие структуры с объявлением значений свойств.

## Примеры

Неправильно

```bsl
НоменклатураСервер.ЗаполнитьСлужебныеРеквизитыПоНоменклатуреВКоллекции(
  Объект.Товары,
  Новый Структура(
  "ЗаполнитьПризнакХарактеристикиИспользуются,
  |ЗаполнитьПризнакТипНоменклатуры, ЗаполнитьПризнакВариантОформленияПродажи",
   Новый Структура("Номенклатура", "ХарактеристикиИспользуются"),
   Новый Структура("Номенклатура", "ТипНоменклатуры"),
   Новый Структура("Номенклатура", "ВариантОформленияПродажи")
  )
 );
```

Правильно

```bsl
ПараметрыЗаполненияРеквизитов = Новый Структура;
ПараметрыЗаполненияРеквизитов.Вставить("ЗаполнитьПризнакХарактеристикиИспользуются",
                                                          Новый Структура("Номенклатура", "ХарактеристикиИспользуются"));
ПараметрыЗаполненияРеквизитов.Вставить("ЗаполнитьПризнакТипНоменклатуры",
                                                          Новый Структура("Номенклатура", "ТипНоменклатуры"));
НоменклатураСервер.ЗаполнитьСлужебныеРеквизитыПоНоменклатуреВКоллекции(Объект.Товары, 
                                                          ПараметрыЗаполненияРеквизитов);
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:NestedConstructorsInStructureDeclaration-off
// BSLLS:NestedConstructorsInStructureDeclaration-on
```

### Параметр конфигурационного файла

```json
"NestedConstructorsInStructureDeclaration": false
```
