# Использование 'ВЫБРАТЬ ПЕРВЫЕ' без 'УПОРЯДОЧИТЬ ПО' (SelectTopWithoutOrderBy)

|      Тип      |    Поддерживаются<br>языки    | Важность |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                      Теги                       |
|:-------------:|:-----------------------------:|:--------:|:------------------------------:|:-----------------------------------:|:-----------------------------------------------:|
| `Дефект кода` |             `BSL`             | `Важный` |              `Да`              |                 `5`                 |       `standard`<br>`sql`<br>`suspicious`       |

## Параметры


|        Имя         |   Тип    |                      Описание                      |    Значение<br>по умолчанию    |
|:------------------:|:--------:|:--------------------------------------------------:|:------------------------------:|
| `skipSelectTopOne` | `Булево` | `Пропускать 'ВЫБРАТЬ ПЕРВЫЕ 1' при наличии отбора` |             `true`             |
<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
<!-- Описание диагностики заполняется вручную. Необходимо понятным языком описать смысл и схему работу -->

Использование конструкции `ПЕРВЫЕ N` без указания порядка сортировки в `УПОРЯДОЧИТЬ ПО` или условий в секции `ГДЕ` чревато получением неожиданных результатов:
- В разных СУБД порядок возвращаемых результатов может отличаться 
- Порядок в разных копиях ИБ будет отличаться от порядка, который ожидает разработчик

По стандарту, отсутствие предложения `УПОРЯДОЧИТЬ ПО` оправдано только в тех случаях, когда
- алгоритм обработки результатов запроса не рассчитывает на определенный порядок записей
- результат обработки выполненного запроса не показывается пользователю
- результат запроса - заведомо одна запись

В приведенных случаях рекомендуется не добавлять предложение `УПОРЯДОЧИТЬ ПО` в текст запроса, так как это приводит к дополнительным затратам времени при выполнении запроса.

### Алгоритм работы диагностики

В процессе анализа считаются ошибочными конструкции
- Использование `ПЕРВЫЕ N` в объединении вне зависимости от наличия `УПОРЯДОЧИТЬ ПО`, т.к. упорядочивание происходит уже после объединения
- Использование `ПЕРВЫЕ N`, где `N > 1` при отсутствии `УПОРЯДОЧИТЬ ПО`
- Использование `ПЕРВЫЕ 1`, при отсутствии `УПОРЯДОЧИТЬ ПО` и условий в `ГДЕ`. Данное правило по умолчанию отключено параметром диагностики 

## Примеры
<!-- В данном разделе приводятся примеры, на которые диагностика срабатывает, а также можно привести пример, как можно исправить ситуацию -->

```bsl
ВЫБРАТЬ ПЕРВЫЕ 1                            // <-- Нет ошибка, есть условие
   Справочник.Ссылка
ИЗ
   Справочник.Контрагенты КАК Справочник
ГДЕ
   Справочник.Ссылка В (
       ВЫБРАТЬ ПЕРВЫЕ 10                   // <-- Ошибка, нет сортировки
           Ссылка
       ИЗ
           Справочник.Контрагенты)
   
ОБЪЕДИНИТЬ ВСЕ
   
ВЫБРАТЬ ПЕРВЫЕ 10                          // <-- Ошибка, нет сортировки (и не может быть)
   Справочник.Ссылка
ИЗ
   Справочник.Контрагенты КАК Справочник
   
ОБЪЕДИНИТЬ ВСЕ
   
ВЫБРАТЬ ПЕРВЫЕ 1                          // <-- Всегда ошибка, даже 1
   Справочник.Ссылка
ИЗ
   Справочник.Контрагенты КАК Справочник

УПОРЯДОЧИТЬ ПО
   Ссылка
```

## Источники
<!-- Необходимо указывать ссылки на все источники, из которых почерпнута информация для создания диагностики -->
<!-- Примеры источников

* Источник: [Стандарт: Тексты модулей](https://its.1c.ru/db/v8std#content:456:hdoc)
* Полезная информация: [Отказ от использования модальных окон](https://its.1c.ru/db/metod8dev#content:5272:hdoc)
* Источник: [Cognitive complexity, ver. 1.4](https://www.sonarsource.com/docs/CognitiveComplexity.pdf) -->

- [Стандарт: Упорядочивание результатов запроса](https://its.1c.ru/db/v8std#content:412:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:SelectTopWithoutOrderBy-off
// BSLLS:SelectTopWithoutOrderBy-on
```

### Параметр конфигурационного файла

```json
"SelectTopWithoutOrderBy": {
    "skipSelectTopOne": true
}
```
