# Использование ключевого слова "ОБЪЕДИНИТЬ" в запросах (UnionAll)

|      Тип      |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |                       Теги                       |
|:-------------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:------------------------------------------------:|
| `Дефект кода` |             `BSL`             | `Незначительный` |              `Да`              |                 `5`                 |       `standard`<br>`sql`<br>`performance`       |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики
В общем случае, при объединении в запросе результатов нескольких запросов следует использовать конструкцию ОБЪЕДИНИТЬ ВСЕ,
а не ОБЪЕДИНИТЬ. Поскольку во втором варианте, при объединении запросов полностью одинаковые строки заменяются одной,
на что затрачивается дополнительное время, даже в случаях, когда одинаковых строк в запросах заведомо быть не может.

Исключением являются ситуации, когда выполнение замены нескольких одинаковых строк одной является необходимым условием
выполнения запроса.

## Примеры

Неправильно:
```bsl
ВЫБРАТЬ
ПоступлениеТоваровУслуг.Ссылка
ИЗ
Документ.ПоступлениеТоваровУслуг КАК ПоступлениеТоваровУслуг

ОБЪЕДИНИТЬ

ВЫБРАТЬ
РеализацияТоваровУслуг.Ссылка
ИЗ
Документ.РеализацияТоваровУслуг КАК РеализацияТоваровУслуг
```

Правильно:

```bsl
ВЫБРАТЬ
ПоступлениеТоваровУслуг.Ссылка
ИЗ
Документ.ПоступлениеТоваровУслуг КАК ПоступлениеТоваровУслуг

ОБЪЕДИНИТЬ ВСЕ

ВЫБРАТЬ
РеализацияТоваровУслуг.Ссылка
ИЗ
Документ.РеализацияТоваровУслуг КАК РеализацияТоваровУслуг
```

## Источники
* Источник: [Стандарт: Использование ключевых слов "ОБЪЕДИНИТЬ" и "ОБЪЕДИНИТЬ ВСЕ" в запросах](https://its.1c.ru/db/v8std#content:434:hdoc)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UnionAll-off
// BSLLS:UnionAll-on
```

### Параметр конфигурационного файла

```json
"UnionAll": false
```
