# Недостижимый код (UnreachableCode)

|   Тип    |    Поддерживаются<br>языки    |     Важность     |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |              Теги              |
|:--------:|:-----------------------------:|:----------------:|:------------------------------:|:-----------------------------------:|:------------------------------:|
| `Ошибка` |         `BSL`<br>`OS`         | `Незначительный` |              `Да`              |                `10`                 |    `design`<br>`suspicious`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

Код, расположенный после операторов "Возврат", "Перейти", "ВызватьИсключение", "Прервать", "Продолжить", никогда не будет исполнен.

Ошибки недостижимого кода могут возникать в результате невнимательности разработчика, при редактировании "чужого кода".

## Примеры

```bsl
Процедура Пример()
    Возврат;
    // Код ниже оператора Возврат никогда не будет исполнен
    Для каждого Строка Из Строки Цикл
        Если Условие2 Тогда
            Метод();
        КонецЕсли;
    КонецЦикла;
КонецПроцедуры
```

```bsl
Функция Пример(Параметр1, Параметр2)
    Если Ошибка Тогда
        ВызватьИсключение "Возникла ошибка";
        // После вызова исключения код будет проигнорирован
        Параметр1 = Параметр2;
    КонецЕсли;
    Возврат Параметр1;
КонецПроцедуры
```

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UnreachableCode-off
// BSLLS:UnreachableCode-on
```

### Параметр конфигурационного файла

```json
"UnreachableCode": false
```
