# Использование объектов недоступных в Unix системах (UsingObjectNotAvailableUnix)

|   Тип    |    Поддерживаются<br>языки    |  Важность   |    Включена<br>по умолчанию    |    Время на<br>исправление (мин)    |              Теги              |
|:--------:|:-----------------------------:|:-----------:|:------------------------------:|:-----------------------------------:|:------------------------------:|
| `Ошибка` |             `BSL`             | `Критичный` |              `Да`              |                `30`                 |    `standard`<br>`lockinos`    |

<!-- Блоки выше заполняются автоматически, не трогать -->
## Описание диагностики

В ОС Linux недоступны механизмы COM, OLE, ActiveDocument. Для интеграции 
необходимо использовать другие средства, например файловый обмен в формате XML или web-сервисы. 
Для внешних компонент, реализованных по COM-технологии, рекомендуется переработать их с использованием технологии NativeAPI.

Отслеживаемые механизмы, недоступные в Linux:

* COMОбъект
* Почта

**Проверка значение выполнения условия пока не выполняется.**

### Дополнительно

При проверке использования недоступных объектов в Linux учитываются условия, в которых можно найти следующий ключевые слова:
* `Linux_x86`
* `Windows`
* `MacOs`

## Примеры

```bsl
Компонента = Новый COMОбъект("System.Text.UTF8Encoding");
```

или

```bsl
Почта = Новый Почта;
```
Вместо этого можно использовать `ЗапуститьПриложение()`.

```bsl
СистемнаяИнформация = Новый СистемнаяИнформация();
Если Не СистемнаяИнформация.ТипПлатформы = ТипПлатформы.Linux_x86 Или ТипПлатформы.Linux_x86_64 Тогда
	Почта = Новый Почта;
КонецЕсли
```

## Источники

* [Особенности разработки кроссплатформенных прикладных решений](https://its.1c.ru/db/v8314doc#bookmark:dev:TI000001208)
* [Особенности работы клиентского приложения под управлением ОС Linux](https://its.1c.ru/db/v8314doc#bookmark:dev:TI000001283)

## Сниппеты

<!-- Блоки ниже заполняются автоматически, не трогать -->
### Экранирование кода

```bsl
// BSLLS:UsingObjectNotAvailableUnix-off
// BSLLS:UsingObjectNotAvailableUnix-on
```

### Параметр конфигурационного файла

```json
"UsingObjectNotAvailableUnix": false
```
