/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.cli.AnalyzeCommand;
import com.github._1c_syntax.bsl.languageserver.cli.FormatCommand;
import com.github._1c_syntax.bsl.languageserver.cli.LanguageServerStartCommand;
import com.github._1c_syntax.bsl.languageserver.cli.VersionCommand;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;
import picocli.CommandLine;

@CommandLine.Command(name="bsl-language-server", subcommands={AnalyzeCommand.class, FormatCommand.class, VersionCommand.class, LanguageServerStartCommand.class}, usageHelpAutoWidth=true, synopsisSubcommandLabel="[COMMAND [ARGS]]", footer={"@|green Copyright(c) 2018-2020|@"}, header={"@|green BSL language server|@"})
@SpringBootApplication
@Component
@ConditionalOnProperty(prefix="app.command.line.runner", value={"enabled"}, havingValue="true", matchIfMissing=true)
public class BSLLSPLauncher
implements Callable<Integer>,
CommandLineRunner,
ExitCodeGenerator {
    private static final String DEFAULT_COMMAND = "lsp";
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message and exit"})
    private boolean usageHelpRequested;
    @CommandLine.Option(names={"-c", "--configuration"}, description={"Path to language server configuration file"}, paramLabel="<path>", defaultValue="")
    private String configurationOption;
    @CommandLine.Unmatched
    private List<String> unmatched;
    private final Set<Pattern> allowedAdditionalArgs = Set.of(CaseInsensitivePattern.compile((String)"--spring\\."), CaseInsensitivePattern.compile((String)"--app\\."), CaseInsensitivePattern.compile((String)"--logging\\."), CaseInsensitivePattern.compile((String)"--debug"));
    private final CommandLine.IFactory picocliFactory;
    private int exitCode;

    public static void main(String[] args) {
        ConfigurableApplicationContext applicationContext = SpringApplication.run(BSLLSPLauncher.class, (String[])args);
        BSLLSPLauncher launcher = (BSLLSPLauncher)applicationContext.getBean(BSLLSPLauncher.class);
        if (launcher.getExitCode() >= 0) {
            System.exit(SpringApplication.exit((ApplicationContext)applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]));
        }
    }

    public void run(String[] args) {
        CommandLine cmd = new CommandLine((Object)this, this.picocliFactory);
        if (args.length == 0) {
            args = BSLLSPLauncher.addDefaultCommand(args);
        } else {
            CommandLine.ParseResult parseResult = cmd.parseArgs(args);
            List<String> unmatchedArgs = parseResult.unmatched().stream().filter(s -> this.allowedAdditionalArgs.stream().noneMatch(pattern -> pattern.matcher((CharSequence)s).matches())).collect(Collectors.toList());
            if (!unmatchedArgs.isEmpty()) {
                unmatchedArgs.forEach(s -> cmd.getErr().println("Unknown option: '" + s + "'"));
                cmd.usage(cmd.getOut());
                this.exitCode = cmd.getCommandSpec().exitCodeOnInvalidInput();
                return;
            }
            if (!parseResult.hasSubcommand() && !parseResult.isUsageHelpRequested()) {
                args = BSLLSPLauncher.addDefaultCommand(args);
            }
        }
        this.exitCode = cmd.execute(args);
    }

    @NotNull
    private static String[] addDefaultCommand(String[] args) {
        ArrayList<String> tmpList = new ArrayList<String>(Arrays.asList(args));
        tmpList.add(0, DEFAULT_COMMAND);
        args = tmpList.toArray(new String[0]);
        return args;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public Integer call() {
        return 0;
    }

    @ConstructorProperties(value={"picocliFactory"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BSLLSPLauncher(CommandLine.IFactory picocliFactory) {
        this.picocliFactory = picocliFactory;
    }
}

