/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.providers.SymbolProvider;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.beanutils.PropertyUtils;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.springframework.stereotype.Component;

@Component
public class BSLWorkspaceService
implements WorkspaceService {
    private final LanguageServerConfiguration configuration;
    private final SymbolProvider symbolProvider;

    public CompletableFuture<List<? extends SymbolInformation>> symbol(WorkspaceSymbolParams params) {
        return CompletableFuture.supplyAsync(() -> this.symbolProvider.getSymbols(params));
    }

    public void didChangeConfiguration(DidChangeConfigurationParams params) {
        try {
            PropertyUtils.copyProperties((Object)this.configuration, (Object)params.getSettings());
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public void didChangeWatchedFiles(DidChangeWatchedFilesParams params) {
    }

    @ConstructorProperties(value={"configuration", "symbolProvider"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public BSLWorkspaceService(LanguageServerConfiguration configuration, SymbolProvider symbolProvider) {
        this.configuration = configuration;
        this.symbolProvider = symbolProvider;
    }
}

