/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver;

import com.github._1c_syntax.bsl.languageserver.events.LanguageServerInitializeRequestReceivedEvent;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.eclipse.lsp4j.services.LanguageServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class ParentProcessWatcher {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ParentProcessWatcher.class);
    private final LanguageServer languageServer;
    private long parentProcessId;

    @EventListener
    public void handleEvent(LanguageServerInitializeRequestReceivedEvent event) {
        Integer processId = event.getParams().getProcessId();
        if (processId == null) {
            return;
        }
        this.parentProcessId = processId.intValue();
    }

    @Scheduled(fixedDelay=30000L)
    public void watch() {
        if (this.parentProcessId == 0L) {
            return;
        }
        boolean processIsAlive = ProcessHandle.of(this.parentProcessId).map(ProcessHandle::isAlive).orElse(false);
        if (!processIsAlive) {
            LOGGER.error("Parent process with pid {} is not found. Closing application...", (Object)this.parentProcessId);
            this.languageServer.exit();
        }
    }

    @ConstructorProperties(value={"languageServer"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ParentProcessWatcher(LanguageServer languageServer) {
        this.languageServer = languageServer;
    }
}

