/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codeactions;

import com.github._1c_syntax.bsl.languageserver.codeactions.CodeActionSupplier;
import com.github._1c_syntax.bsl.languageserver.codeactions.QuickFixSupplier;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractQuickFixSupplier
implements CodeActionSupplier {
    protected final QuickFixSupplier quickFixSupplier;

    @Override
    public List<CodeAction> getCodeActions(CodeActionParams params, DocumentContext documentContext) {
        List only = params.getContext().getOnly();
        if (only != null && !only.isEmpty() && !only.contains("quickfix")) {
            return Collections.emptyList();
        }
        List incomingDiagnostics = params.getContext().getDiagnostics();
        if (incomingDiagnostics.isEmpty()) {
            return Collections.emptyList();
        }
        Set computedDiagnostics = documentContext.getComputedDiagnostics().stream().map(LightDiagnostic::new).collect(Collectors.toSet());
        Stream<Diagnostic> diagnosticStream = incomingDiagnostics.stream().filter(diagnostic -> computedDiagnostics.contains(new LightDiagnostic((Diagnostic)diagnostic)));
        return this.processDiagnosticStream(diagnosticStream, params, documentContext).collect(Collectors.toList());
    }

    protected abstract Stream<CodeAction> processDiagnosticStream(Stream<Diagnostic> var1, CodeActionParams var2, DocumentContext var3);

    @ConstructorProperties(value={"quickFixSupplier"})
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public AbstractQuickFixSupplier(QuickFixSupplier quickFixSupplier) {
        this.quickFixSupplier = quickFixSupplier;
    }

    private static final class LightDiagnostic {
        private final Either<String, Integer> code;
        private final Range range;
        private final String source;

        public LightDiagnostic(Diagnostic diagnostic) {
            this.code = diagnostic.getCode();
            this.range = diagnostic.getRange();
            this.source = diagnostic.getSource();
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Either<String, Integer> getCode() {
            return this.code;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Range getRange() {
            return this.range;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getSource() {
            return this.source;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LightDiagnostic)) {
                return false;
            }
            LightDiagnostic other = (LightDiagnostic)o;
            Either<String, Integer> this$code = this.getCode();
            Either<String, Integer> other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            Range this$range = this.getRange();
            Range other$range = other.getRange();
            if (this$range == null ? other$range != null : !this$range.equals(other$range)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            return !(this$source == null ? other$source != null : !this$source.equals(other$source));
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Either<String, Integer> $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            Range $range = this.getRange();
            result = result * 59 + ($range == null ? 43 : $range.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            return result;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String toString() {
            return "AbstractQuickFixSupplier.LightDiagnostic(code=" + this.getCode() + ", range=" + this.getRange() + ", source=" + this.getSource() + ")";
        }
    }
}

