/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codeactions;

import com.github._1c_syntax.bsl.languageserver.codeactions.CodeActionSupplier;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.bsl.languageserver.utils.Ranges;
import com.github._1c_syntax.bsl.languageserver.utils.Resources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Token;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class DisableDiagnosticTriggeringSupplier
implements CodeActionSupplier {
    private static final String ALL_DIAGNOSTIC_NAME = "";
    private final LanguageServerConfiguration languageServerConfiguration;

    public DisableDiagnosticTriggeringSupplier(LanguageServerConfiguration languageServerConfiguration) {
        this.languageServerConfiguration = languageServerConfiguration;
    }

    @Override
    public List<CodeAction> getCodeActions(CodeActionParams params, DocumentContext documentContext) {
        ArrayList<CodeAction> result = new ArrayList<CodeAction>();
        if (!params.getContext().getDiagnostics().isEmpty()) {
            if (params.getRange().getStart() != null && params.getRange().getEnd() != null) {
                int selectedLineNumber = params.getRange().getEnd().getLine() + 1;
                documentContext.getTokens().stream().filter(token -> token.getLine() == selectedLineNumber).max(Comparator.comparingInt(Token::getCharPositionInLine)).ifPresent(token -> {
                    if (params.getRange().getStart().getLine() == params.getRange().getEnd().getLine()) {
                        result.addAll(this.getDisableActionForLine(params, documentContext, (Token)token));
                    } else {
                        result.addAll(this.getDisableActionForRange(params, documentContext, (Token)token));
                    }
                });
            }
            result.addAll(this.actionDisableDiagnostic(name -> this.createCodeAction(this.getMessage("file", name), this.createInFileTextEdits(":" + name), documentContext), params));
        }
        result.add(this.createCodeAction(this.getMessage("fileAll"), this.createInFileTextEdits(ALL_DIAGNOSTIC_NAME), documentContext));
        return new ArrayList<CodeAction>(result);
    }

    private List<CodeAction> getDisableActionForLine(CodeActionParams params, DocumentContext documentContext, Token lastToken) {
        List<CodeAction> result = this.actionDisableDiagnostic(name -> this.createCodeAction(this.getMessage("line", name), DisableDiagnosticTriggeringSupplier.createInLineTextEdits(":" + name, lastToken, params), documentContext), params);
        result.add(this.createCodeAction(this.getMessage("lineAll"), DisableDiagnosticTriggeringSupplier.createInLineTextEdits(ALL_DIAGNOSTIC_NAME, lastToken, params), documentContext));
        return result;
    }

    private List<CodeAction> getDisableActionForRange(CodeActionParams params, DocumentContext documentContext, Token lastToken) {
        List<CodeAction> result = this.actionDisableDiagnostic(name -> this.createCodeAction(this.getMessage("range", name), this.createInRegionTextEdits(":" + name, lastToken, params), documentContext), params);
        result.add(this.createCodeAction(this.getMessage("rangeAll"), this.createInRegionTextEdits(ALL_DIAGNOSTIC_NAME, lastToken, params), documentContext));
        return result;
    }

    private List<CodeAction> actionDisableDiagnostic(Function<String, CodeAction> func, CodeActionParams params) {
        return params.getContext().getDiagnostics().stream().filter(diagnostic -> "bsl-language-server".equals(diagnostic.getSource())).map(Diagnostic::getCode).map(DiagnosticCode::getStringValue).distinct().map(func).collect(Collectors.toList());
    }

    private List<TextEdit> createInRegionTextEdits(String diagnosticName, Token last, CodeActionParams params) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        Range disableRange = Ranges.create(params.getRange().getStart().getLine(), 0, params.getRange().getStart().getLine(), 0);
        TextEdit disableTextEdit = new TextEdit(disableRange, String.format("// BSLLS%s-off%n", diagnosticName));
        edits.add(disableTextEdit);
        Range enableRange = Ranges.create(params.getRange().getEnd().getLine(), last.getCharPositionInLine() + last.getText().length(), params.getRange().getEnd().getLine(), last.getCharPositionInLine() + last.getText().length());
        TextEdit enableTextEdit = new TextEdit(enableRange, String.format("%n// BSLLS%s-on%n", diagnosticName));
        edits.add(enableTextEdit);
        return edits;
    }

    private List<TextEdit> createInFileTextEdits(String diagnosticName) {
        TextEdit textEdit = new TextEdit(Ranges.create(0, 0, 0, 0), String.format("// BSLLS%s-off%n", diagnosticName));
        return Collections.singletonList(textEdit);
    }

    @NotNull
    private CodeAction createCodeAction(String title, List<TextEdit> edits, DocumentContext documentContext) {
        Map<String, List<TextEdit>> changes = Map.of(documentContext.getUri().toString(), edits);
        WorkspaceEdit edit = new WorkspaceEdit();
        edit.setChanges(changes);
        CodeAction codeAction = new CodeAction(title);
        codeAction.setDiagnostics(new ArrayList());
        codeAction.setKind("refactor");
        codeAction.setEdit(edit);
        return codeAction;
    }

    private String getMessage(String key) {
        return Resources.getResourceString(this.languageServerConfiguration.getLanguage(), this.getClass(), key);
    }

    private String getMessage(String key, Object ... args) {
        return Resources.getResourceString(this.languageServerConfiguration.getLanguage(), this.getClass(), key, args);
    }

    private static List<TextEdit> createInLineTextEdits(String diagnosticName, Token last, CodeActionParams params) {
        Range range = Ranges.create(params.getRange().getStart().getLine(), last.getCharPositionInLine() + last.getText().length(), params.getRange().getStart().getLine(), last.getCharPositionInLine() + last.getText().length());
        TextEdit textEdit = new TextEdit(range, String.format(" // BSLLS%s-off", diagnosticName));
        return Collections.singletonList(textEdit);
    }
}

