/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.codeactions;

import com.github._1c_syntax.bsl.languageserver.codeactions.AbstractQuickFixSupplier;
import com.github._1c_syntax.bsl.languageserver.codeactions.QuickFixSupplier;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.diagnostics.QuickFixProvider;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.springframework.stereotype.Component;

@Component
public class QuickFixCodeActionSupplier
extends AbstractQuickFixSupplier {
    public QuickFixCodeActionSupplier(QuickFixSupplier quickFixSupplier) {
        super(quickFixSupplier);
    }

    @Override
    protected Stream<CodeAction> processDiagnosticStream(Stream<Diagnostic> diagnosticStream, CodeActionParams params, DocumentContext documentContext) {
        return diagnosticStream.flatMap(diagnostic -> this.getCodeActionsByDiagnostic((Diagnostic)diagnostic, params, documentContext).stream());
    }

    private List<CodeAction> getCodeActionsByDiagnostic(Diagnostic diagnostic, CodeActionParams params, DocumentContext documentContext) {
        Optional<Class<QuickFixProvider>> quickFixClass = this.quickFixSupplier.getQuickFixClass(diagnostic.getCode());
        if (quickFixClass.isEmpty()) {
            return Collections.emptyList();
        }
        Class<QuickFixProvider> quickFixProviderClass = quickFixClass.get();
        QuickFixProvider quickFixInstance = this.quickFixSupplier.getQuickFixInstance(quickFixProviderClass);
        return quickFixInstance.getQuickFixes(Collections.singletonList(diagnostic), params, documentContext);
    }
}

