/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.utils.MdoRefBuilder;
import com.github._1c_syntax.mdclasses.Configuration;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.utils.Absolute;
import com.github._1c_syntax.utils.Lazy;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.CheckForNull;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Lookup;
import org.springframework.stereotype.Component;

@Component
public abstract class ServerContext {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger LOGGER;
    private final Map<URI, DocumentContext> documents = Collections.synchronizedMap(new HashMap());
    private final Lazy<Configuration> configurationMetadata = new Lazy(this::computeConfigurationMetadata);
    @CheckForNull
    private Path configurationRoot;
    private final Map<URI, String> mdoRefs = Collections.synchronizedMap(new HashMap());
    private final Map<String, Map<ModuleType, DocumentContext>> documentsByMDORef = Collections.synchronizedMap(new HashMap());
    private final ReadWriteLock contextLock = new ReentrantReadWriteLock();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public void populateContext() {
        if (this.configurationRoot == null) {
            LOGGER.info("Can't populate server context. Configuration root is not defined.");
            return;
        }
        LOGGER.debug("Finding files to populate context...");
        Collection files = FileUtils.listFiles((File)this.configurationRoot.toFile(), (String[])new String[]{"bsl", "os"}, (boolean)true);
        this.populateContext(files);
    }

    public void populateContext(Collection<File> uris) {
        Collection<File> collection = uris;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, collection);
        MeasuresAspect.aspectOf().initializeConfiguration(joinPoint, collection);
        LOGGER.debug("Populating context...");
        this.contextLock.writeLock().lock();
        uris.parallelStream().forEach(file -> {
            DocumentContext documentContext = this.getDocument(file.toURI());
            if (documentContext == null) {
                documentContext = this.createDocumentContext((File)file, 0);
                documentContext.clearSecondaryData();
            }
        });
        this.contextLock.writeLock().unlock();
        LOGGER.debug("Context populated.");
    }

    public Map<URI, DocumentContext> getDocuments() {
        return Collections.unmodifiableMap(this.documents);
    }

    @CheckForNull
    public DocumentContext getDocument(String uri) {
        return this.getDocument(URI.create(uri));
    }

    public Optional<DocumentContext> getDocument(String mdoRef, ModuleType moduleType) {
        Map<ModuleType, DocumentContext> documentsGroup = this.documentsByMDORef.get(mdoRef);
        if (documentsGroup != null) {
            return Optional.ofNullable(documentsGroup.get(moduleType));
        }
        return Optional.empty();
    }

    @CheckForNull
    public DocumentContext getDocument(URI uri) {
        return this.documents.get(Absolute.uri((URI)uri));
    }

    public Map<ModuleType, DocumentContext> getDocuments(String mdoRef) {
        return this.documentsByMDORef.getOrDefault(mdoRef, Collections.emptyMap());
    }

    public DocumentContext addDocument(URI uri, String content, int version) {
        this.contextLock.readLock().lock();
        DocumentContext documentContext = this.getDocument(uri);
        if (documentContext == null) {
            documentContext = this.createDocumentContext(uri, content, version);
        } else {
            documentContext.rebuild(content, version);
        }
        this.contextLock.readLock().unlock();
        return documentContext;
    }

    public DocumentContext addDocument(TextDocumentItem textDocumentItem) {
        return this.addDocument(URI.create(textDocumentItem.getUri()), textDocumentItem.getText(), textDocumentItem.getVersion());
    }

    public void removeDocument(URI uri) {
        URI absoluteURI = Absolute.uri((URI)uri);
        this.removeDocumentMdoRefByUri(absoluteURI);
        this.documents.remove(absoluteURI);
    }

    public void clear() {
        this.documents.clear();
        this.documentsByMDORef.clear();
        this.mdoRefs.clear();
        this.configurationMetadata.clear();
    }

    public Configuration getConfiguration() {
        return (Configuration)this.configurationMetadata.getOrCompute();
    }

    @Lookup
    protected abstract DocumentContext lookupDocumentContext(URI var1);

    private DocumentContext createDocumentContext(File file, int version) {
        String content = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
        return this.createDocumentContext(file.toURI(), content, version);
    }

    private DocumentContext createDocumentContext(URI uri, String content, int version) {
        URI absoluteURI = Absolute.uri((URI)uri);
        DocumentContext documentContext = this.lookupDocumentContext(absoluteURI);
        documentContext.rebuild(content, version);
        this.documents.put(absoluteURI, documentContext);
        this.addMdoRefByUri(absoluteURI, documentContext);
        documentContext.getSymbolTree();
        return documentContext;
    }

    private Configuration computeConfigurationMetadata() {
        Configuration configuration;
        if (this.configurationRoot == null) {
            return Configuration.create();
        }
        ForkJoinPool customThreadPool = new ForkJoinPool();
        try {
            configuration = (Configuration)((ForkJoinTask)customThreadPool.submit(() -> Configuration.create((Path)this.configurationRoot))).fork().join();
        }
        catch (RuntimeException e) {
            LOGGER.error("Can't parse configuration metadata. Execution exception.", (Throwable)e);
            configuration = Configuration.create();
        }
        return configuration;
    }

    private void addMdoRefByUri(URI uri, DocumentContext documentContext) {
        String mdoRef = MdoRefBuilder.getMdoRef(documentContext);
        this.mdoRefs.put(uri, mdoRef);
        this.documentsByMDORef.computeIfAbsent(mdoRef, k -> new EnumMap(ModuleType.class)).put(documentContext.getModuleType(), documentContext);
    }

    private void removeDocumentMdoRefByUri(URI uri) {
        String mdoRef = this.mdoRefs.get(uri);
        if (mdoRef != null) {
            Map<ModuleType, DocumentContext> documentsGroup = this.documentsByMDORef.get(mdoRef);
            if (documentsGroup != null) {
                documentsGroup.remove(this.documents.get(uri).getModuleType());
                if (documentsGroup.isEmpty()) {
                    this.documentsByMDORef.remove(mdoRef);
                }
            }
            this.mdoRefs.remove(uri);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public ServerContext() {
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfigurationRoot(@CheckForNull Path configurationRoot) {
        this.configurationRoot = configurationRoot;
    }

    static {
        ServerContext.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(ServerContext.class);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ServerContext.java", ServerContext.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "populateContext", "com.github._1c_syntax.bsl.languageserver.context.ServerContext", "java.util.Collection", "uris", "", "void"), 82);
    }
}

