/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.context.computer;

import com.github._1c_syntax.bsl.languageserver.aop.MeasuresAspect;
import com.github._1c_syntax.bsl.languageserver.context.DocumentContext;
import com.github._1c_syntax.bsl.languageserver.context.computer.Computer;
import com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticIgnoranceComputer$AjcClosure1;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticCode;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.ConstructorProperties;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.CheckForNull;
import lombok.Generated;
import org.antlr.v4.runtime.Token;
import org.apache.commons.lang3.Range;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.eclipse.lsp4j.Diagnostic;

public class DiagnosticIgnoranceComputer
implements Computer<Data> {
    private static final DiagnosticCode ALL_DIAGNOSTICS_KEY;
    private static final Pattern IGNORE_ALL_ON;
    private static final Pattern IGNORE_ALL_OFF;
    private static final Pattern IGNORE_DIAGNOSTIC_ON;
    private static final Pattern IGNORE_DIAGNOSTIC_OFF;
    private final DocumentContext documentContext;
    private final Map<DiagnosticCode, List<Range<Integer>>> diagnosticIgnorance = new HashMap<DiagnosticCode, List<Range<Integer>>>();
    private final Map<DiagnosticCode, Deque<Integer>> ignoranceStack = new HashMap<DiagnosticCode, Deque<Integer>>();
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public DiagnosticIgnoranceComputer(DocumentContext documentContext) {
        this.documentContext = documentContext;
    }

    @Override
    public Data compute() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        DiagnosticIgnoranceComputer$AjcClosure1 diagnosticIgnoranceComputer$AjcClosure1 = new DiagnosticIgnoranceComputer$AjcClosure1(objectArray);
        return (Data)MeasuresAspect.aspectOf().measureComputers(diagnosticIgnoranceComputer$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private boolean checkTrailingComment(Set<Integer> codeLines, Token comment) {
        int commentLine = comment.getLine();
        if (!codeLines.contains(commentLine)) {
            return false;
        }
        DiagnosticCode key = this.checkIgnoreOff(IGNORE_ALL_OFF, comment);
        if (key == null) {
            key = this.checkIgnoreOff(IGNORE_DIAGNOSTIC_OFF, comment);
        }
        if (key == null) {
            return false;
        }
        Deque<Integer> stack = this.ignoranceStack.get((Object)key);
        stack.pop();
        this.addIgnoredRange(key, commentLine, commentLine);
        return true;
    }

    @CheckForNull
    private DiagnosticCode checkIgnoreOff(Pattern ignoreOff, Token comment) {
        Matcher matcher = ignoreOff.matcher(comment.getText());
        if (!matcher.find()) {
            return null;
        }
        DiagnosticCode key = DiagnosticIgnoranceComputer.getKey(matcher);
        Deque stack = this.ignoranceStack.computeIfAbsent(key, s -> new ArrayDeque());
        stack.push(comment.getLine());
        return key;
    }

    private boolean checkIgnoreOn(Pattern ignoreOn, Token comment) {
        Matcher matcher = ignoreOn.matcher(comment.getText());
        if (!matcher.find()) {
            return false;
        }
        DiagnosticCode key = DiagnosticIgnoranceComputer.getKey(matcher);
        Deque stack = this.ignoranceStack.computeIfAbsent(key, s -> new ArrayDeque());
        if (stack.isEmpty()) {
            return false;
        }
        int ignoreRangeStart = (Integer)stack.pop();
        int ignoreRangeEnd = comment.getLine();
        this.addIgnoredRange(key, ignoreRangeStart, ignoreRangeEnd);
        return true;
    }

    private void addIgnoredRange(DiagnosticCode diagnosticKey, int ignoreRangeStart, int ignoreRangeEnd) {
        Range ignoreRange = Range.between((Comparable)Integer.valueOf(ignoreRangeStart - 1), (Comparable)Integer.valueOf(ignoreRangeEnd - 1));
        List ranges = this.diagnosticIgnorance.computeIfAbsent(diagnosticKey, s -> new ArrayList());
        ranges.add(ignoreRange);
    }

    private static DiagnosticCode getKey(Matcher matcher) {
        DiagnosticCode key = matcher.groupCount() != 0 ? new DiagnosticCode(matcher.group(1)) : ALL_DIAGNOSTICS_KEY;
        return key;
    }

    static {
        DiagnosticIgnoranceComputer.ajc$preClinit();
        ALL_DIAGNOSTICS_KEY = new DiagnosticCode("all");
        IGNORE_ALL_ON = CaseInsensitivePattern.compile((String)"BSLLS-(?:\u0432\u043a\u043b|on)");
        IGNORE_ALL_OFF = CaseInsensitivePattern.compile((String)"BSLLS-(?:\u0432\u044b\u043a\u043b|off)");
        IGNORE_DIAGNOSTIC_ON = CaseInsensitivePattern.compile((String)"BSLLS:(\\w+)-(?:\u0432\u043a\u043b|on)");
        IGNORE_DIAGNOSTIC_OFF = CaseInsensitivePattern.compile((String)"BSLLS:(\\w+)-(?:\u0432\u044b\u043a\u043b|off)");
    }

    static final /* synthetic */ Data compute_aroundBody0(DiagnosticIgnoranceComputer ajc$this, JoinPoint joinPoint) {
        ajc$this.diagnosticIgnorance.clear();
        ajc$this.ignoranceStack.clear();
        List<Token> codeTokens = ajc$this.documentContext.getTokensFromDefaultChannel();
        if (codeTokens.isEmpty()) {
            return new Data(ajc$this.diagnosticIgnorance);
        }
        Set<Integer> codeLines = codeTokens.stream().map(Token::getLine).collect(Collectors.toSet());
        List<Token> comments = ajc$this.documentContext.getComments();
        for (Token comment : comments) {
            boolean bl = ajc$this.checkTrailingComment(codeLines, comment) || ajc$this.checkIgnoreOff(IGNORE_ALL_OFF, comment) != null || ajc$this.checkIgnoreOn(IGNORE_ALL_ON, comment) || ajc$this.checkIgnoreOff(IGNORE_DIAGNOSTIC_OFF, comment) != null || ajc$this.checkIgnoreOn(IGNORE_DIAGNOSTIC_ON, comment);
        }
        int lastTokenLine = codeTokens.get(codeTokens.size() - 1).getLine();
        ajc$this.ignoranceStack.forEach((diagnosticKey, ignoreRangeStarts) -> ignoreRangeStarts.forEach(ignoreRangeStart -> this.addIgnoredRange((DiagnosticCode)((Object)diagnosticKey), (int)ignoreRangeStart, lastTokenLine)));
        return new Data(ajc$this.diagnosticIgnorance);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("DiagnosticIgnoranceComputer.java", DiagnosticIgnoranceComputer.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "compute", "com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticIgnoranceComputer", "", "", "", "com.github._1c_syntax.bsl.languageserver.context.computer.DiagnosticIgnoranceComputer$Data"), 78);
    }

    public static class Data {
        private final Map<DiagnosticCode, List<Range<Integer>>> diagnosticIgnorance;

        public boolean diagnosticShouldBeIgnored(Diagnostic diagnostic) {
            if (this.diagnosticIgnorance.isEmpty()) {
                return false;
            }
            int line = diagnostic.getRange().getStart().getLine();
            Predicate<Map.Entry> ignoreAll = entry -> ((DiagnosticCode)((Object)((Object)entry.getKey()))).equals((Object)ALL_DIAGNOSTICS_KEY);
            Predicate<Map.Entry> ignoreConcreteDiagnostic = entry -> ((DiagnosticCode)((Object)((Object)entry.getKey()))).equals(diagnostic.getCode());
            return this.diagnosticIgnorance.entrySet().stream().filter(ignoreAll.or(ignoreConcreteDiagnostic)).map(Map.Entry::getValue).flatMap(Collection::stream).anyMatch(range -> range.contains((Object)line));
        }

        @ConstructorProperties(value={"diagnosticIgnorance"})
        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Data(Map<DiagnosticCode, List<Range<Integer>>> diagnosticIgnorance) {
            this.diagnosticIgnorance = diagnosticIgnorance;
        }
    }
}

