/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=1, activatedByDefault=false, tags={DiagnosticTag.DESIGN})
public class BadWordsDiagnostic
extends AbstractDiagnostic {
    private static final String BAD_WORDS_DEFAULT = "";
    @DiagnosticParameter(type=String.class, defaultValue="")
    private Pattern badWords = CaseInsensitivePattern.compile((String)"");

    @Override
    public void configure(Map<String, Object> configuration) {
        this.badWords = CaseInsensitivePattern.compile((String)((String)configuration.getOrDefault("badWords", BAD_WORDS_DEFAULT)));
    }

    @Override
    protected void check() {
        if (this.badWords.pattern().isBlank()) {
            return;
        }
        String[] moduleLines = this.documentContext.getContentList();
        for (int i = 0; i < moduleLines.length; ++i) {
            Matcher matcher = this.badWords.matcher(moduleLines[i]);
            while (matcher.find()) {
                this.diagnosticStorage.addDiagnostic(i, matcher.start(), i, matcher.end());
            }
        }
    }
}

