/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=10, tags={DiagnosticTag.SUSPICIOUS}, activatedByDefault=false, scope=DiagnosticScope.BSL, modules={ModuleType.CommandModule, ModuleType.FormModule, ModuleType.ManagedApplicationModule})
public class CodeAfterAsyncCallDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern ASYNC_METHODS = CaseInsensitivePattern.compile((String)"\u041f\u041e\u041a\u0410\u0417\u0410\u0422\u042c\u0412\u041e\u041f\u0420\u041e\u0421|SHOWQUERYBOX|\u041e\u0422\u041a\u0420\u042b\u0422\u042c\u0424\u041e\u0420\u041c\u0423|OPENFORM|\u041f\u041e\u041a\u0410\u0417\u0410\u0422\u042c\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u0415|SHOWVALUE|\u041f\u041e\u041a\u0410\u0417\u0410\u0422\u042c\u041f\u0420\u0415\u0414\u0423\u041f\u0420\u0415\u0416\u0414\u0415\u041d\u0418\u0415|SHOWMESSAGEBOX|\u041f\u041e\u041a\u0410\u0417\u0410\u0422\u042c\u0412\u0412\u041e\u0414\u0414\u0410\u0422\u042b|SHOWINPUTDATE|\u041f\u041e\u041a\u0410\u0417\u0410\u0422\u042c\u0412\u0412\u041e\u0414\u0417\u041d\u0410\u0427\u0415\u041d\u0418\u042f|SHOWINPUTVALUE|\u041f\u041e\u041a\u0410\u0417\u0410\u0422\u042c\u0412\u0412\u041e\u0414\u0421\u0422\u0420\u041e\u041a\u0418|SHOWINPUTSTRING|\u041f\u041e\u041a\u0410\u0417\u0410\u0422\u042c\u0412\u0412\u041e\u0414\u0427\u0418\u0421\u041b\u0410|SHOWINPUTNUMBER|\u041d\u0410\u0427\u0410\u0422\u042c\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0423\u0412\u041d\u0415\u0428\u041d\u0415\u0419\u041a\u041e\u041c\u041f\u041e\u041d\u0415\u041d\u0422\u042b|BEGININSTALLADDIN|\u041d\u0410\u0427\u0410\u0422\u042c\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0423\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u042f\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u0424\u0410\u0419\u041b\u0410\u041c\u0418|BEGININSTALLFILESYSTEMEXTENSION|\u041d\u0410\u0427\u0410\u0422\u042c\u0423\u0421\u0422\u0410\u041d\u041e\u0412\u041a\u0423\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u042f\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u041a\u0420\u0418\u041f\u0422\u041e\u0413\u0420\u0410\u0424\u0418\u0415\u0419|BEGININSTALLCRYPTOEXTENSION|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u0414\u041a\u041b\u042e\u0427\u0415\u041d\u0418\u0415\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u042f\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u041a\u0420\u0418\u041f\u0422\u041e\u0413\u0420\u0410\u0424\u0418\u0415\u0419|BEGINATTACHINGCRYPTOEXTENSION|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u0414\u041a\u041b\u042e\u0427\u0415\u041d\u0418\u0415\u0420\u0410\u0421\u0428\u0418\u0420\u0415\u041d\u0418\u042f\u0420\u0410\u0411\u041e\u0422\u042b\u0421\u0424\u0410\u0419\u041b\u0410\u041c\u0418|BEGINATTACHINGFILESYSTEMEXTENSION|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u041c\u0415\u0429\u0415\u041d\u0418\u0415\u0424\u0410\u0419\u041b\u0410|BEGINPUTFILE|\u041d\u0410\u0427\u0410\u0422\u042c\u041a\u041e\u041f\u0418\u0420\u041e\u0412\u0410\u041d\u0418\u0415\u0424\u0410\u0419\u041b\u0410|BEGINCOPYINGFILE|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u0415\u0420\u0415\u041c\u0415\u0429\u0415\u041d\u0418\u0415\u0424\u0410\u0419\u041b\u0410|BEGINMOVINGFILE|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u0418\u0421\u041a\u0424\u0410\u0419\u041b\u041e\u0412|BEGINFINDINGFILES|\u041d\u0410\u0427\u0410\u0422\u042c\u0423\u0414\u0410\u041b\u0415\u041d\u0418\u0415\u0424\u0410\u0419\u041b\u041e\u0412|BEGINDELETINGFILES|\u041d\u0410\u0427\u0410\u0422\u042c\u0421\u041e\u0417\u0414\u0410\u041d\u0418\u0415\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0410|BEGINCREATINGDIRECTORY|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u041b\u0423\u0427\u0415\u041d\u0418\u0415\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0410\u0412\u0420\u0415\u041c\u0415\u041d\u041d\u042b\u0425\u0424\u0410\u0419\u041b\u041e\u0412|BEGINGETTINGTEMPFILESDIR|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u041b\u0423\u0427\u0415\u041d\u0418\u0415\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0410\u0414\u041e\u041a\u0423\u041c\u0415\u041d\u0422\u041e\u0412|BEGINGETTINGDOCUMENTSDIR|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u041b\u0423\u0427\u0415\u041d\u0418\u0415\u0420\u0410\u0411\u041e\u0427\u0415\u0413\u041e\u041a\u0410\u0422\u0410\u041b\u041e\u0413\u0410\u0414\u0410\u041d\u041d\u042b\u0425\u041f\u041e\u041b\u042c\u0417\u041e\u0412\u0410\u0422\u0415\u041b\u042f|BEGINGETTINGUSERDATAWORKDIR|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u041b\u0423\u0427\u0415\u041d\u0418\u0415\u0424\u0410\u0419\u041b\u041e\u0412|BEGINGETTINGFILES|\u041d\u0410\u0427\u0410\u0422\u042c\u041f\u041e\u041c\u0415\u0429\u0415\u041d\u0418\u0415\u0424\u0410\u0419\u041b\u041e\u0412|BEGINPUTTINGFILES|\u041d\u0410\u0427\u0410\u0422\u042c\u0417\u0410\u041f\u0420\u041e\u0421\u0420\u0410\u0417\u0420\u0415\u0428\u0415\u041d\u0418\u042f\u041f\u041e\u041b\u042c\u0417\u041e\u0412\u0410\u0422\u0415\u041b\u042f|BEGINREQUESTINGUSERPERMISSION|\u041d\u0410\u0427\u0410\u0422\u042c\u0417\u0410\u041f\u0423\u0421\u041a\u041f\u0420\u0418\u041b\u041e\u0416\u0415\u041d\u0418\u042f|BEGINRUNNINGAPPLICATION");
    private static final List<Integer> ROOT_INDEXES = Arrays.asList(77, 41);
    private Optional<BSLParser.CodeBlockContext> subCodeBlockContext = Optional.empty();

    private static boolean checkNextBlocks(BSLParser.StatementContext statement) {
        BSLParser.CodeBlockContext codeBlock = (BSLParser.CodeBlockContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)statement, 69);
        if (codeBlock == null || codeBlock.statement().isEmpty()) {
            return false;
        }
        if (Trees.getNextNode((ParseTree)codeBlock, (ParseTree)statement, 77) != null) {
            return true;
        }
        return CodeAfterAsyncCallDiagnostic.checkParentBlock(codeBlock);
    }

    private static boolean checkParentBlock(BSLParser.CodeBlockContext codeBlock) {
        BSLParserRuleContext rootStatement = Trees.getRootParent((BSLParserRuleContext)codeBlock, ROOT_INDEXES);
        if (rootStatement != null && rootStatement.getRuleIndex() == 77) {
            return CodeAfterAsyncCallDiagnostic.checkNextBlocks((BSLParser.StatementContext)rootStatement);
        }
        return false;
    }

    public ParseTree visitFile(BSLParser.FileContext ctx) {
        this.subCodeBlockContext = Optional.empty();
        return (ParseTree)super.visitFile(ctx);
    }

    public ParseTree visitSubCodeBlock(BSLParser.SubCodeBlockContext ctx) {
        this.subCodeBlockContext = Optional.of(ctx.codeBlock());
        return (ParseTree)super.visitSubCodeBlock(ctx);
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        BSLParser.StatementContext statement;
        String methodName;
        boolean nonFileCodeBlock = this.subCodeBlockContext.isPresent();
        if (nonFileCodeBlock && ASYNC_METHODS.matcher(methodName = ctx.methodName().getText()).matches() && (statement = (BSLParser.StatementContext)Trees.getAncestorByRuleIndex((BSLParserRuleContext)ctx, 77)) != null && CodeAfterAsyncCallDiagnostic.checkNextBlocks(statement)) {
            this.diagnosticStorage.addDiagnostic((BSLParserRuleContext)ctx, this.info.getMessage(methodName));
        }
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }
}

