/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.Trees;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=10, tags={DiagnosticTag.STANDARD})
public class CommitTransactionOutsideTryCatchDiagnostic
extends AbstractVisitorDiagnostic {
    private static final Pattern END_TRANSACTION_PATTERN = CaseInsensitivePattern.compile((String)"\u0417\u0430\u0444\u0438\u043a\u0441\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0422\u0440\u0430\u043d\u0437\u0430\u043a\u0446\u0438\u044e|CommitTransaction");
    private BSLParserRuleContext nodeEndTransaction = null;
    private BSLParser.StatementContext nodeEndFile = null;

    private static boolean isGlobalMethodCommitTransaction(BSLParser.StatementContext ctx) {
        if (ctx.getStart().getType() != 76) {
            return false;
        }
        return ctx.getChildCount() > 0 && ctx.getChild(0).getChildCount() > 0 && ctx.getChild(0).getChild(0) instanceof BSLParser.GlobalMethodCallContext && END_TRANSACTION_PATTERN.matcher(ctx.getText()).find();
    }

    public ParseTree visitExceptCodeBlock(BSLParser.ExceptCodeBlockContext ctx) {
        this.nodeEndTransaction = null;
        return (ParseTree)super.visitExceptCodeBlock(ctx);
    }

    public ParseTree visitStatement(BSLParser.StatementContext ctx) {
        if (ctx.getStart().getType() == 59) {
            if (this.nodeEndTransaction != null) {
                this.diagnosticStorage.addDiagnostic(this.nodeEndTransaction);
            }
            this.nodeEndTransaction = null;
            return (ParseTree)super.visitStatement(ctx);
        }
        if (this.nodeEndTransaction != null) {
            this.diagnosticStorage.addDiagnostic(this.nodeEndTransaction);
            this.nodeEndTransaction = null;
        }
        if (CommitTransactionOutsideTryCatchDiagnostic.isGlobalMethodCommitTransaction(ctx)) {
            this.nodeEndTransaction = ctx;
        }
        if (this.nodeEndFile != null && this.nodeEndTransaction != null && this.nodeEndFile.equals(ctx)) {
            this.diagnosticStorage.addDiagnostic(this.nodeEndTransaction);
            this.nodeEndTransaction = null;
        }
        return (ParseTree)super.visitStatement(ctx);
    }

    public ParseTree visitSubCodeBlock(BSLParser.SubCodeBlockContext ctx) {
        super.visitSubCodeBlock(ctx);
        if (this.nodeEndTransaction != null) {
            this.diagnosticStorage.addDiagnostic(this.nodeEndTransaction);
            this.nodeEndTransaction = null;
        }
        return ctx;
    }

    public ParseTree visitFileCodeBlock(BSLParser.FileCodeBlockContext ctx) {
        Stream<ParseTree> statements = Trees.findAllRuleNodes((ParseTree)ctx, 77).stream();
        this.nodeEndFile = statements.reduce((a, b) -> b).orElse(null);
        return (ParseTree)super.visitFileCodeBlock(ctx);
    }
}

