/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import com.github._1c_syntax.utils.CaseInsensitivePattern;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=5, tags={DiagnosticTag.BADPRACTICE, DiagnosticTag.BRAINOVERLOAD})
public class MagicDateDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String DEFAULT_AUTHORIZED_DATES = "00010101,00010101000000,000101010000";
    private static final Pattern methodPattern = CaseInsensitivePattern.compile((String)"\u0414\u0430\u0442\u0430|Date");
    private static final Pattern paramPattern = CaseInsensitivePattern.compile((String)"\"\\d{8}.*");
    private static final Pattern nonNumberPattern = CaseInsensitivePattern.compile((String)"\\D");
    @DiagnosticParameter(type=String.class, defaultValue="00010101,00010101000000,000101010000")
    private final Set<String> authorizedDates = new HashSet<String>(Arrays.asList("00010101,00010101000000,000101010000".split(",")));

    @Override
    public void configure(Map<String, Object> configuration) {
        String authorizedDatesString = (String)configuration.getOrDefault("authorizedDates", DEFAULT_AUTHORIZED_DATES);
        Set authD = Arrays.stream(authorizedDatesString.split(",")).map(String::trim).collect(Collectors.toSet());
        this.authorizedDates.clear();
        this.authorizedDates.addAll(authD);
    }

    public ParseTree visitGlobalMethodCall(BSLParser.GlobalMethodCallContext ctx) {
        Optional.of(ctx).filter(it -> methodPattern.matcher(it.methodName().getText()).matches()).map(BSLParser.GlobalMethodCallContext::doCall).map(BSLParser.DoCallContext::callParamList).filter(callParamList -> paramPattern.matcher(callParamList.getText()).matches()).ifPresent(this::checkExclAddDiagnostic);
        return (ParseTree)super.visitGlobalMethodCall(ctx);
    }

    public ParseTree visitConstValue(BSLParser.ConstValueContext ctx) {
        TerminalNode tNode = ctx.DATETIME();
        if (tNode != null) {
            this.checkExclAddDiagnostic((BSLParserRuleContext)ctx);
        }
        return ctx;
    }

    private void checkExclAddDiagnostic(BSLParserRuleContext ctx) {
        BSLParserRuleContext expression;
        String checked = ctx.getText();
        if (checked != null && !this.isExcluded(checked) && (expression = ctx instanceof BSLParser.CallParamListContext ? ctx.getParent().getParent().getParent().getParent().getParent() : ctx.getParent().getParent()) instanceof BSLParser.ExpressionContext && !MagicDateDiagnostic.isAssignExpression((BSLParser.ExpressionContext)expression)) {
            this.diagnosticStorage.addDiagnostic(ctx.stop, this.info.getMessage(checked));
        }
    }

    private boolean isExcluded(String sIn) {
        String s = nonNumberPattern.matcher(sIn).replaceAll("");
        return this.authorizedDates.contains(s);
    }

    private static boolean isAssignExpression(BSLParser.ExpressionContext expression) {
        return expression.getChildCount() <= 1;
    }
}

