/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractVisitorDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.bsl.languageserver.utils.DiagnosticHelper;
import com.github._1c_syntax.bsl.parser.BSLParser;
import com.github._1c_syntax.bsl.parser.BSLParserRuleContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.antlr.v4.runtime.tree.ParseTree;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MINOR, minutesToFix=1, tags={DiagnosticTag.BADPRACTICE})
public class MagicNumberDiagnostic
extends AbstractVisitorDiagnostic {
    private static final String DEFAULT_AUTHORIZED_NUMBERS = "-1,0,1";
    private static final boolean DEFAULT_ALLOW_MAGIC_NUMBER = true;
    @DiagnosticParameter(type=String.class, defaultValue="-1,0,1")
    private final List<String> authorizedNumbers = new ArrayList<String>(Arrays.asList("-1,0,1".split(",")));
    @DiagnosticParameter(type=Boolean.class, defaultValue="true")
    private boolean allowMagicIndexes = true;

    @Override
    public void configure(Map<String, Object> configuration) {
        DiagnosticHelper.configureDiagnostic(this, configuration, "allowMagicIndexes");
        this.authorizedNumbers.clear();
        String authorizedNumbersString = (String)configuration.getOrDefault("authorizedNumbers", DEFAULT_AUTHORIZED_NUMBERS);
        for (String s : authorizedNumbersString.split(",")) {
            this.authorizedNumbers.add(s.trim());
        }
    }

    public ParseTree visitNumeric(BSLParser.NumericContext ctx) {
        BSLParserRuleContext expression;
        String checked = ctx.getText();
        if (checked != null && !this.isExcluded(checked) && (expression = ctx.getParent().getParent().getParent()) instanceof BSLParser.ExpressionContext && (!MagicNumberDiagnostic.isNumericExpression((BSLParser.ExpressionContext)expression) || this.mayBeNumberAccess((BSLParser.ExpressionContext)expression))) {
            this.diagnosticStorage.addDiagnostic(ctx.stop, this.info.getMessage(checked));
        }
        return ctx;
    }

    private boolean isExcluded(String s) {
        for (String elem : this.authorizedNumbers) {
            if (s.compareTo(elem) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean mayBeNumberAccess(BSLParser.ExpressionContext expression) {
        return !this.allowMagicIndexes && expression.getParent() instanceof BSLParser.AccessIndexContext;
    }

    private static boolean isNumericExpression(BSLParser.ExpressionContext expression) {
        return expression.getChildCount() <= 1;
    }
}

