/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.configuration.Language;
import com.github._1c_syntax.bsl.languageserver.configuration.LanguageServerConfiguration;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractMetadataDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticParameter;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticScope;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import com.github._1c_syntax.mdclasses.mdo.AbstractMDObjectBase;
import com.github._1c_syntax.mdclasses.mdo.support.MDOType;
import com.github._1c_syntax.mdclasses.mdo.support.ModuleType;
import java.util.List;

@DiagnosticMetadata(type=DiagnosticType.ERROR, severity=DiagnosticSeverity.MAJOR, minutesToFix=10, scope=DiagnosticScope.BSL, tags={DiagnosticTag.STANDARD})
public class MetadataObjectNameLengthDiagnostic
extends AbstractMetadataDiagnostic {
    private final LanguageServerConfiguration serverConfiguration;
    private static final int MAX_METADATA_OBJECT_NAME_LENGTH = 80;
    @DiagnosticParameter(type=Integer.class, defaultValue="80")
    private int maxMetadataObjectNameLength = 80;

    MetadataObjectNameLengthDiagnostic(LanguageServerConfiguration serverConfiguration) {
        super(List.of(MDOType.values()));
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    protected void checkMetadata(AbstractMDObjectBase mdo) {
        if (mdo.getName().length() > this.maxMetadataObjectNameLength) {
            this.addAttributeDiagnostic(mdo);
        }
    }

    @Override
    protected void check() {
        if (this.documentContext.getModuleType() == ModuleType.CommandModule || this.documentContext.getModuleType() == ModuleType.FormModule) {
            if (this.computeDiagnosticRange()) {
                this.documentContext.getMdObject().ifPresent(this::checkMetadata);
            }
        } else {
            super.check();
        }
    }

    private void addAttributeDiagnostic(AbstractMDObjectBase attribute) {
        String mdoRef = this.serverConfiguration.getLanguage() == Language.RU ? attribute.getMdoReference().getMdoRefRu() : attribute.getMdoReference().getMdoRef();
        this.addDiagnostic(this.info.getMessage(mdoRef, this.maxMetadataObjectNameLength));
    }
}

