/*
 * Decompiled with CFR 0.152.
 */
package com.github._1c_syntax.bsl.languageserver.diagnostics;

import com.github._1c_syntax.bsl.languageserver.context.symbol.MethodSymbol;
import com.github._1c_syntax.bsl.languageserver.context.symbol.ParameterDefinition;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.MethodDescription;
import com.github._1c_syntax.bsl.languageserver.context.symbol.description.ParameterDescription;
import com.github._1c_syntax.bsl.languageserver.diagnostics.AbstractSymbolTreeDiagnostic;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticMetadata;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticSeverity;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticTag;
import com.github._1c_syntax.bsl.languageserver.diagnostics.metadata.DiagnosticType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.map.CaseInsensitiveMap;

@DiagnosticMetadata(type=DiagnosticType.CODE_SMELL, severity=DiagnosticSeverity.MAJOR, minutesToFix=5, tags={DiagnosticTag.STANDARD, DiagnosticTag.BADPRACTICE})
public class MissingParameterDescriptionDiagnostic
extends AbstractSymbolTreeDiagnostic {
    @Override
    public void visitMethod(MethodSymbol methodSymbol) {
        Optional<MethodDescription> description = methodSymbol.getDescription();
        boolean hasDescription = description.isPresent();
        if (!hasDescription) {
            return;
        }
        List<ParameterDefinition> parameters = methodSymbol.getParameters();
        List<ParameterDescription> parametersDescriptions = description.map(MethodDescription::getParameters).orElse(Collections.emptyList());
        if (parameters.isEmpty() && parametersDescriptions.isEmpty()) {
            return;
        }
        if (parameters.isEmpty()) {
            this.addDiagnostic(methodSymbol, parametersDescriptions);
            return;
        }
        if (parametersDescriptions.isEmpty()) {
            if (!description.get().getLink().isEmpty()) {
                return;
            }
            this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange());
            return;
        }
        this.checkParameterDescription(methodSymbol, parameters, parametersDescriptions);
    }

    private void checkParameterDescription(MethodSymbol methodSymbol, List<ParameterDefinition> parameters, List<ParameterDescription> parametersDescriptions) {
        String paramString;
        String paramDescriptionString;
        AtomicBoolean hasMissingDescription = new AtomicBoolean(false);
        ArrayList<ParameterDescription> parametersDescriptionsCopy = new ArrayList<ParameterDescription>(parametersDescriptions);
        CaseInsensitiveMap descriptions = parametersDescriptions.stream().collect(Collectors.toMap(ParameterDescription::getName, Function.identity(), (first, second) -> first, CaseInsensitiveMap::new));
        parameters.forEach(parameter -> {
            ParameterDescription description = (ParameterDescription)descriptions.get((Object)parameter.getName());
            if (description == null) {
                this.addDiagnostic((ParameterDefinition)parameter, "missingDescription");
                hasMissingDescription.set(true);
                return;
            }
            if (description.getTypes().isEmpty()) {
                this.addDiagnostic((ParameterDefinition)parameter, "emptyDescription");
            }
            parametersDescriptionsCopy.remove(description);
        });
        if (!parametersDescriptionsCopy.isEmpty()) {
            hasMissingDescription.set(true);
            this.addDiagnostic(methodSymbol, parametersDescriptionsCopy);
        }
        if (!hasMissingDescription.get() && !(paramDescriptionString = parametersDescriptions.stream().map(ParameterDescription::getName).collect(Collectors.joining(",")).toLowerCase(Locale.ENGLISH)).equals(paramString = parameters.stream().map(ParameterDefinition::getName).collect(Collectors.joining(",")).toLowerCase(Locale.ENGLISH))) {
            this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), this.info.getResourceString("wrongOrder"));
        }
    }

    private void addDiagnostic(ParameterDefinition parameter, String messageKey) {
        this.diagnosticStorage.addDiagnostic(parameter.getRange(), this.info.getResourceString(messageKey, parameter.getName()));
    }

    private void addDiagnostic(MethodSymbol methodSymbol, List<ParameterDescription> parametersDescriptions) {
        String parametersString = parametersDescriptions.stream().map(ParameterDescription::getName).collect(Collectors.joining(", "));
        this.diagnosticStorage.addDiagnostic(methodSymbol.getSubNameRange(), this.info.getResourceString("missingInSignature", parametersString));
    }
}

